/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j;

import java.net.URI;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.internal.pac4j.AuthFilter;
import org.pac4j.http.client.indirect.FormClient;
import org.pac4j.http.profile.HttpProfile;

public class FormFilter
extends AuthFilter {
    private static final String FORM = "<!DOCTYPE html>\n<html>\n<head>\n<title>Login Page</title>\n<script type=\"text/javascript\">\n\n  function submitForm() {\n    document.form.submit();\n  }\n\n  function onKeyPressEvent(event) {\n    var key = event.keyCode || event.which;\n    if (key === 13) {\n      if (event.preventDefault) {\n        event.preventDefault();\n      } else {\n        event.returnValue = false;\n      }\n\n      submitForm('');\n      return false;\n    }\n  }\n</script>\n</head>\n<body onload=\"document.form.username.focus();\">\n  <h3>Login</h3>\n  <p style=\"color: red;\">\n  %s\n  </p>\n  <form name=\"form\" action=\"%s\" method=\"POST\">\n    <input name=\"username\" onkeypress=\"onKeyPressEvent(event)\" value=\"%s\" />\n    <p></p>\n    <input type=\"password\" name=\"password\" onkeypress=\"onKeyPressEvent(event)\" />\n    <p></p>\n    <input type=\"submit\" value=\"Submit\" />\n  </form>\n</body>\n</html>\n";
    private String loginUrl;
    private String callback;

    public FormFilter(String loginUrl, String callback) {
        super(FormClient.class, HttpProfile.class);
        this.loginUrl = loginUrl;
        this.callback = URI.create(callback).getPath() + "?client_name=FormClient";
    }

    @Override
    public void handle(Request req, Response rsp, Route.Chain chain) throws Exception {
        String error = req.param("error").toOptional().orElse("");
        String username = req.param("username").toOptional().orElse("");
        req.set("username", (Object)username);
        req.set("error", (Object)error);
        if (this.loginUrl.equals(req.path())) {
            rsp.type(MediaType.html).send((Object)String.format(FORM, error, this.callback, username));
        } else {
            super.handle(req, rsp, chain);
        }
    }
}

