/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j;

import java.util.Objects;
import java.util.Optional;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Session;
import org.jooby.pac4j.Auth;
import org.jooby.pac4j.AuthStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthLogout
implements Route.Handler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String redirectTo;

    public AuthLogout(String redirectTo) {
        this.redirectTo = Objects.requireNonNull(redirectTo, "RedirectTo is required.");
    }

    public void handle(Request req, Response rsp) throws Exception {
        Optional ifSession = req.ifSession();
        if (ifSession.isPresent()) {
            Optional profileId = ((Session)ifSession.get()).unset(Auth.ID).toOptional();
            if (profileId.isPresent()) {
                Optional profile = ((AuthStore)req.require(AuthStore.class)).unset((String)profileId.get());
                this.log.debug("logout {}", profile);
            }
        } else {
            this.log.debug("nothing to logout from session");
        }
        String redirectTo = req.get("auth.logout.redirectTo").orElse(this.redirectTo);
        rsp.redirect(redirectTo);
    }
}

