/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.pac4j;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jooby.Session;
import org.jooby.pac4j.AuthStore;
import org.pac4j.core.profile.UserProfile;

public class AuthSessionStore
implements AuthStore<UserProfile> {
    private static final String SEP = "__;_;";
    private static final String CLASS = "class";
    private static final String REMEMBERED = "remembered";
    private static final String PERMISSIONS = "permissions";
    private static final String ROLES = "roles";
    private static final Set<String> SPECIAL_PROPERTIES = ImmutableSet.of((Object)"class", (Object)"remembered", (Object)"permissions");
    private Provider<Session> session;

    @Inject
    public AuthSessionStore(Provider<Session> session) {
        this.session = Objects.requireNonNull(session, "Session is required.");
    }

    @Override
    public Optional<UserProfile> get(String id) throws Exception {
        String prefix;
        String classKey;
        Session session = (Session)this.session.get();
        Map attributes = session.attributes();
        String classname = (String)attributes.get(classKey = AuthSessionStore.key(prefix = AuthSessionStore.key(id), CLASS));
        if (classname == null) {
            return Optional.empty();
        }
        UserProfile profile = (UserProfile)this.getClass().getClassLoader().loadClass(classname).newInstance();
        attributes.forEach((k, v) -> {
            String key;
            if (k.startsWith(prefix) && !SPECIAL_PROPERTIES.contains(key = k.substring(prefix.length() + 1))) {
                profile.addAttribute(key, v);
            }
        });
        profile.setRemembered(session.get(AuthSessionStore.key(prefix, REMEMBERED)).booleanValue());
        profile.setId((Object)id);
        profile.addPermissions(Splitter.on((String)SEP).splitToList((CharSequence)session.get(AuthSessionStore.key(prefix, PERMISSIONS)).value()));
        profile.addRoles(Splitter.on((String)SEP).splitToList((CharSequence)session.get(AuthSessionStore.key(prefix, ROLES)).value()));
        return Optional.of(profile);
    }

    @Override
    public void set(UserProfile profile) {
        Session session = (Session)this.session.get();
        Map attributes = profile.getAttributes();
        String prefix = AuthSessionStore.key(profile.getId());
        attributes.forEach((k, v) -> session.set(AuthSessionStore.key(prefix, k), v.toString()));
        session.set(AuthSessionStore.key(prefix, REMEMBERED), profile.isRemembered());
        session.set(AuthSessionStore.key(prefix, CLASS), profile.getClass().getName());
        session.set(AuthSessionStore.key(prefix, PERMISSIONS), Joiner.on((String)SEP).join((Iterable)profile.getPermissions()));
        session.set(AuthSessionStore.key(prefix, ROLES), Joiner.on((String)SEP).join((Iterable)profile.getRoles()));
    }

    @Override
    public Optional<UserProfile> unset(String id) throws Exception {
        Session session = (Session)this.session.get();
        Optional<UserProfile> profile = this.get(id);
        String prefix = AuthSessionStore.key(id);
        Map attributes = session.attributes();
        attributes.forEach((k, v) -> {
            if (k.startsWith(prefix)) {
                session.unset(k);
            }
        });
        return profile;
    }

    private static String key(String property) {
        return AuthSessionStore.key("pac4jUserProfile", property);
    }

    private static String key(String prefix, String property) {
        return prefix + "." + property;
    }
}

