/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j;

import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Primitives;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class AuthSerializer {
    private static final String PREFIX = "b64~";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Object strToObject(String value) {
        if (value == null) return value;
        if (!value.startsWith(PREFIX)) {
            return value;
        }
        byte[] bytes = BaseEncoding.base64().decode((CharSequence)value.substring(PREFIX.length()));
        try (ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = stream.readObject();
            return object;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't de-serialize value " + value, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String objToStr(Object value) {
        if (value instanceof CharSequence) return value.toString();
        if (Primitives.isWrapperType(value.getClass())) {
            return value.toString();
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream stream = new ObjectOutputStream(bytes);){
            stream.writeObject(value);
            stream.flush();
            String string = PREFIX + BaseEncoding.base64().encode(bytes.toByteArray());
            return string;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't serialize value " + value, ex);
        }
    }
}

