/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.pac4j;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Binder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Route;
import org.jooby.internal.pac4j.AuthCallback;
import org.jooby.internal.pac4j.AuthContext;
import org.jooby.internal.pac4j.AuthFilter;
import org.jooby.internal.pac4j.AuthLogout;
import org.jooby.internal.pac4j.AuthorizerFilter;
import org.jooby.internal.pac4j.BasicAuth;
import org.jooby.internal.pac4j.ClientType;
import org.jooby.internal.pac4j.ClientsProvider;
import org.jooby.internal.pac4j.ConfigProvider;
import org.jooby.internal.pac4j.FormAuth;
import org.jooby.internal.pac4j.FormFilter;
import org.jooby.pac4j.AuthSessionStore;
import org.jooby.pac4j.AuthStore;
import org.jooby.scope.RequestScoped;
import org.jooby.util.Providers;
import org.pac4j.core.authorization.AuthorizationChecker;
import org.pac4j.core.authorization.Authorizer;
import org.pac4j.core.authorization.DefaultAuthorizationChecker;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.ClientFinder;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.DefaultClientFinder;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.http.client.indirect.IndirectBasicAuthClient;
import org.pac4j.http.credentials.authenticator.UsernamePasswordAuthenticator;
import org.pac4j.http.credentials.authenticator.test.SimpleTestUsernamePasswordAuthenticator;
import org.pac4j.http.profile.HttpProfile;

public class Auth
implements Jooby.Module {
    public static final String ID = Auth.class.getName() + ".id";
    private Multimap<String, BiFunction<Binder, Config, AuthFilter>> bindings = ArrayListMultimap.create();
    private Class<? extends AuthStore> storeClass = AuthSessionStore.class;
    private Optional<String> logoutUrl = Optional.empty();
    private Optional<String> redirecTo = Optional.empty();
    private Multimap<String, Map.Entry<String, Object>> authorizers = ArrayListMultimap.create();
    private Set<Object> bindedProfiles = new HashSet<Object>();

    public Auth authorizer(String name, String pattern, Authorizer<?> authorizer) {
        this.authorizer(authorizer, name, pattern);
        return this;
    }

    public Auth authorizer(String name, String pattern, Class<? extends Authorizer> authorizer) {
        this.authorizer(authorizer, name, pattern);
        return this;
    }

    private void authorizer(Object authorizer, String name, String pattern) {
        Objects.requireNonNull(name, "An authorizer's name is required.");
        Objects.requireNonNull(pattern, "An authorizer's pattern is required.");
        Objects.requireNonNull(authorizer, "An authorizer is required.");
        this.authorizers.put((Object)pattern, (Object)Maps.immutableEntry((Object)name, (Object)authorizer));
    }

    public Auth form(String pattern, Class<? extends UsernamePasswordAuthenticator> authenticator) {
        this.bindings.put((Object)pattern, (binder, conf) -> {
            binder.bind(UsernamePasswordAuthenticator.class).to(authenticator);
            this.bindProfile((Binder)binder, HttpProfile.class);
            Multibinder.newSetBinder((Binder)binder, Client.class).addBinding().toProvider(FormAuth.class);
            return new FormFilter(conf.getString("auth.form.loginUrl"), conf.getString("auth.callback"));
        });
        return this;
    }

    public Auth form(String pattern) {
        return this.form(pattern, SimpleTestUsernamePasswordAuthenticator.class);
    }

    public Auth form() {
        return this.form("*");
    }

    public Auth basic(String pattern, Class<? extends UsernamePasswordAuthenticator> authenticator) {
        this.bindings.put((Object)pattern, (binder, config) -> {
            binder.bind(UsernamePasswordAuthenticator.class).to(authenticator);
            this.bindProfile((Binder)binder, HttpProfile.class);
            Multibinder.newSetBinder((Binder)binder, Client.class).addBinding().toProvider(BasicAuth.class);
            return new AuthFilter(IndirectBasicAuthClient.class, HttpProfile.class);
        });
        return this;
    }

    public Auth basic(String pattern) {
        return this.basic(pattern, SimpleTestUsernamePasswordAuthenticator.class);
    }

    public Auth basic() {
        return this.basic("*");
    }

    public <C extends Credentials, U extends UserProfile> Auth client(Client<C, U> client) {
        return this.client("*", client);
    }

    public <C extends Credentials, U extends UserProfile> Auth client(Class<? extends Client<C, U>> client) {
        return this.client("*", client);
    }

    public <C extends Credentials, U extends UserProfile> Auth client(String pattern, Client<C, U> client) {
        return this.client(pattern, (Config config) -> client);
    }

    public <C extends Credentials, U extends UserProfile> Auth client(Function<Config, Client<C, U>> provider) {
        return this.client("*", provider);
    }

    public <C extends Credentials, U extends UserProfile> Auth client(String pattern, Function<Config, Client<C, U>> provider) {
        this.bindings.put((Object)pattern, (binder, config) -> {
            Client client = (Client)provider.apply((Config)config);
            Multibinder.newSetBinder((Binder)binder, Client.class).addBinding().toInstance((Object)client);
            Class<?> clientType = client.getClass();
            Class<? extends UserProfile> profileType = ClientType.typeOf(clientType);
            this.bindProfile((Binder)binder, profileType);
            return new AuthFilter(clientType, profileType);
        });
        return this;
    }

    public <C extends Credentials, U extends UserProfile> Auth client(String pattern, Class<? extends Client<C, U>> client) {
        this.bindings.put((Object)pattern, (binder, config) -> {
            Multibinder.newSetBinder((Binder)binder, Client.class).addBinding().to(client);
            Class<? extends UserProfile> profileType = ClientType.typeOf(client);
            this.bindProfile((Binder)binder, profileType);
            return new AuthFilter(client, profileType);
        });
        return this;
    }

    public <U extends UserProfile> Auth store(Class<? extends AuthStore<U>> store) {
        this.storeClass = Objects.requireNonNull(store, "Store is required.");
        return this;
    }

    public Auth logout(String logoutUrl, String redirecTo) {
        this.logoutUrl = Optional.of(logoutUrl);
        this.redirecTo = Optional.of(redirecTo);
        return this;
    }

    public Auth logout(String logoutUrl) {
        this.logoutUrl = Optional.of(logoutUrl);
        this.redirecTo = Optional.empty();
        return this;
    }

    public void configure(Env env, Config config, Binder binder) {
        binder.bind(Clients.class).toProvider(ClientsProvider.class);
        binder.bind(org.pac4j.core.config.Config.class).toProvider(ConfigProvider.class);
        OptionalBinder.newOptionalBinder((Binder)binder, AuthorizationChecker.class).setDefault().toInstance((Object)new DefaultAuthorizationChecker());
        OptionalBinder.newOptionalBinder((Binder)binder, ClientFinder.class).setDefault().toInstance((Object)new DefaultClientFinder());
        String fullcallback = config.getString("auth.callback");
        String callback = URI.create(fullcallback).getPath();
        Multibinder routes = Multibinder.newSetBinder((Binder)binder, Route.Definition.class);
        MapBinder authorizers = MapBinder.newMapBinder((Binder)binder, String.class, Authorizer.class);
        routes.addBinding().toInstance((Object)new Route.Definition("*", callback, (req, rsp, chain) -> ((AuthCallback)req.require(AuthCallback.class)).handle(req, rsp, chain)).excludes(new String[]{"/favicon.ico"}).name("auth(Callback)"));
        routes.addBinding().toInstance((Object)new Route.Definition("*", this.logoutUrl.orElse(config.getString("auth.logout.url")), (Route.Handler)new AuthLogout(this.redirecTo.orElse(config.getString("auth.logout.redirectTo")))).name("auth(Logout)"));
        if (this.bindings.size() == 0) {
            this.form();
        }
        this.bindings.asMap().entrySet().forEach(e -> {
            String pattern = (String)e.getKey();
            ArrayList filters = new ArrayList();
            ((Collection)e.getValue()).forEach(it -> {
                AuthFilter filter = (AuthFilter)it.apply(binder, config);
                if (filters.size() == 0) {
                    filters.add(filter);
                } else {
                    ((AuthFilter)filters.get(0)).setName(filter.getName());
                }
            });
            AuthFilter head = (AuthFilter)filters.get(0);
            this.filter(binder, pattern, head.getName(), () -> head);
        });
        binder.bind(AuthCallback.class);
        binder.bind(AuthStore.class).to(this.storeClass);
        binder.bind(WebContext.class).to(AuthContext.class).in(RequestScoped.class);
        this.authorizers.asMap().entrySet().forEach(e -> {
            String pattern = (String)e.getKey();
            String names = ((Collection)e.getValue()).stream().map(Map.Entry::getKey).collect(Collectors.joining(","));
            routes.addBinding().toInstance((Object)new Route.Definition("*", pattern, (Route.Handler)new AuthorizerFilter(names)).name("auth(" + names + ")"));
            ((Collection)e.getValue()).forEach(v -> {
                String name = (String)v.getKey();
                Object authorizer = v.getValue();
                if (authorizer instanceof Authorizer) {
                    authorizers.addBinding((Object)name).toInstance((Object)((Authorizer)authorizer));
                } else {
                    authorizers.addBinding((Object)name).to((Class)authorizer);
                }
            });
        });
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"auth.conf");
    }

    private void filter(Binder binder, String pattern, String name, Supplier<Route.Filter> filter) {
        Multibinder.newSetBinder((Binder)binder, Route.Definition.class).addBinding().toInstance((Object)new Route.Definition("*", pattern, filter.get()).name("auth(" + name + ")").excludes(new String[]{"/favicon.ico"}));
    }

    private void bindProfile(Binder binder, Class root) {
        for (Class profile = root; profile != Object.class; profile = profile.getSuperclass()) {
            if (!this.bindedProfiles.add(profile)) continue;
            binder.bind(profile).toProvider(Providers.outOfScope(profile)).in(RequestScoped.class);
        }
    }
}

