/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j;

import java.util.Objects;
import java.util.Optional;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.internal.pac4j.AuthResponse;
import org.jooby.pac4j.Auth;
import org.jooby.pac4j.AuthStore;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthFilter
implements Route.Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Class<? extends Client<?, ?>> clientType;
    private Class<? extends UserProfile> profileType;
    private AuthStore<UserProfile> store;

    public AuthFilter(Class<? extends Client<?, ?>> clientType, Class<? extends UserProfile> profileType, AuthStore<UserProfile> store) {
        this.clientType = Objects.requireNonNull(clientType, "ClientType is required.");
        this.profileType = Objects.requireNonNull(profileType, "ProfileType is required.");
        this.store = Objects.requireNonNull(store, "Auth store is required.");
    }

    public void handle(Request req, Response rsp, Route.Chain chain) throws Exception {
        Optional profile;
        Optional profileId = req.session().get(Auth.ID).toOptional();
        Optional<Object> optional = profile = profileId.isPresent() ? this.store.get((String)profileId.get()) : Optional.empty();
        if (profile.isPresent()) {
            UserProfile userprofile = (UserProfile)profile.get();
            req.set(this.profileType, (Object)userprofile);
            this.log.debug("profile found: {}", (Object)userprofile);
            chain.next(req, rsp);
        } else {
            this.log.debug("profile not found");
            req.session().set("pac4jRequestedUrl", req.path());
            WebContext ctx = (WebContext)req.require(WebContext.class);
            Clients clients = (Clients)req.require(Clients.class);
            Client client = clients.findClient(this.clientType);
            try {
                client.redirect(ctx, true, req.xhr());
                rsp.end();
            }
            catch (RequiresHttpAction ex) {
                new AuthResponse(rsp).handle(client, ex);
            }
        }
    }
}

