/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.pac4j;

import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Route;
import org.jooby.internal.pac4j.AuthCallback;
import org.jooby.internal.pac4j.AuthContext;
import org.jooby.internal.pac4j.AuthFilter;
import org.jooby.internal.pac4j.AuthLogout;
import org.jooby.internal.pac4j.BasicAuth;
import org.jooby.internal.pac4j.ClientType;
import org.jooby.internal.pac4j.ClientsProvider;
import org.jooby.internal.pac4j.FormAuth;
import org.jooby.internal.pac4j.FormFilter;
import org.jooby.pac4j.AuthSessionStore;
import org.jooby.pac4j.AuthStore;
import org.jooby.scope.RequestScoped;
import org.jooby.util.Providers;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.http.client.BasicAuthClient;
import org.pac4j.http.credentials.SimpleTestUsernamePasswordAuthenticator;
import org.pac4j.http.credentials.UsernamePasswordAuthenticator;
import org.pac4j.http.profile.HttpProfile;
import org.pac4j.http.profile.UsernameProfileCreator;

public class Auth
implements Jooby.Module {
    public static final String ID = Auth.class.getName() + ".id";
    private List<BiConsumer<Binder, Config>> bindings = new ArrayList<BiConsumer<Binder, Config>>();
    private Class<? extends AuthStore<? extends UserProfile>> storeClass = AuthSessionStore.class;
    private Optional<String> logoutUrl = Optional.empty();
    private Optional<String> redirecTo = Optional.empty();

    public Auth form(String pattern, Class<? extends UsernamePasswordAuthenticator> authenticator, Class<? extends UsernameProfileCreator> profileCreator) {
        this.bindings.add((binder, config) -> {
            binder.bind(UsernamePasswordAuthenticator.class).to(authenticator);
            if (profileCreator == UsernameProfileCreator.class) {
                binder.bind(UsernameProfileCreator.class);
            } else {
                binder.bind(UsernameProfileCreator.class).to(profileCreator);
            }
            binder.bind(HttpProfile.class).toProvider(Providers.outOfScope(HttpProfile.class)).in(RequestScoped.class);
            Multibinder.newSetBinder((Binder)binder, Client.class).addBinding().toProvider(FormAuth.class).asEagerSingleton();
            this.filter((Binder)binder, pattern, "Form", () -> (req, rsp, chain) -> new FormFilter((AuthStore)req.require(AuthStore.class), config.getString("auth.form.loginUrl"), config.getString("auth.callback")).handle(req, rsp, chain));
        });
        return this;
    }

    public Auth form(String pattern, Class<? extends UsernamePasswordAuthenticator> authenticator) {
        return this.form(pattern, authenticator, UsernameProfileCreator.class);
    }

    public Auth form(String pattern) {
        return this.form(pattern, SimpleTestUsernamePasswordAuthenticator.class);
    }

    public Auth form() {
        return this.form("*");
    }

    public Auth basic(String pattern, Class<? extends UsernamePasswordAuthenticator> authenticator, Class<? extends UsernameProfileCreator> profileCreator) {
        this.bindings.add((binder, config) -> {
            binder.bind(UsernamePasswordAuthenticator.class).to(authenticator);
            if (profileCreator == UsernameProfileCreator.class) {
                binder.bind(UsernameProfileCreator.class);
            } else {
                binder.bind(UsernameProfileCreator.class).to(profileCreator);
            }
            binder.bind(HttpProfile.class).toProvider(Providers.outOfScope(HttpProfile.class)).in(RequestScoped.class);
            Multibinder.newSetBinder((Binder)binder, Client.class).addBinding().toProvider(BasicAuth.class).asEagerSingleton();
            this.filter((Binder)binder, pattern, "Basic", () -> (req, rsp, chain) -> new AuthFilter(BasicAuthClient.class, HttpProfile.class, (AuthStore)req.require(AuthStore.class)).handle(req, rsp, chain));
        });
        return this;
    }

    public Auth basic(String pattern, Class<? extends UsernamePasswordAuthenticator> authenticator) {
        return this.basic(pattern, authenticator, UsernameProfileCreator.class);
    }

    public Auth basic(String pattern) {
        return this.basic(pattern, SimpleTestUsernamePasswordAuthenticator.class);
    }

    public Auth basic() {
        return this.basic("*");
    }

    public <C extends Credentials, U extends UserProfile> Auth client(Client<C, U> client) {
        return this.client("*", client);
    }

    public <C extends Credentials, U extends UserProfile> Auth client(String pattern, Client<C, U> client) {
        return this.client(pattern, (Config config) -> client);
    }

    public <C extends Credentials, U extends UserProfile> Auth client(Function<Config, Client<C, U>> provider) {
        return this.client("*", provider);
    }

    public <C extends Credentials, U extends UserProfile> Auth client(String pattern, Function<Config, Client<C, U>> provider) {
        this.bindings.add((binder, config) -> {
            Client client = (Client)provider.apply((Config)config);
            Multibinder.newSetBinder((Binder)binder, Client.class).addBinding().toInstance(provider.apply((Config)config));
            this.filter((Binder)binder, pattern, true, (Class<? extends Client<?, ?>>)client.getClass());
        });
        return this;
    }

    public <U extends UserProfile> Auth store(Class<? extends AuthStore<U>> store) {
        this.storeClass = Objects.requireNonNull(store, "Store is required.");
        return this;
    }

    public Auth logout(String logoutUrl, String redirecTo) {
        this.logoutUrl = Optional.of(logoutUrl);
        this.redirecTo = Optional.of(redirecTo);
        return this;
    }

    public Auth logout(String logoutUrl) {
        this.logoutUrl = Optional.of(logoutUrl);
        this.redirecTo = Optional.empty();
        return this;
    }

    public void configure(Env env, Config config, Binder binder) {
        binder.bind(Clients.class).toProvider(ClientsProvider.class);
        String fullcallback = config.getString("auth.callback");
        String callback = URI.create(fullcallback).getPath();
        Multibinder routes = Multibinder.newSetBinder((Binder)binder, Route.Definition.class);
        routes.addBinding().toInstance((Object)new Route.Definition("*", callback, (req, rsp, chain) -> ((AuthCallback)req.require(AuthCallback.class)).handle(req, rsp, chain)).name("auth(Callback)"));
        routes.addBinding().toInstance((Object)new Route.Definition("*", this.logoutUrl.orElse(config.getString("auth.logout.url")), (Route.Handler)new AuthLogout(this.redirecTo.orElse(config.getString("auth.logout.redirectTo")))).name("auth(Logout)"));
        if (this.bindings.size() == 0) {
            this.form();
        }
        this.bindings.forEach(it -> it.accept(binder, config));
        binder.bind(AuthStore.class).to(this.storeClass).asEagerSingleton();
        binder.bind(WebContext.class).to(AuthContext.class).in(RequestScoped.class);
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"auth.conf");
    }

    private void filter(Binder binder, String pattern, boolean stateless, Class<? extends Client<?, ?>> client) {
        String name = client.getSimpleName().replace("Client", "");
        Class<? extends UserProfile> profileType = ClientType.typeOf(client);
        binder.bind(profileType).toProvider(Providers.outOfScope(profileType)).in(RequestScoped.class);
        this.filter(binder, pattern, name, () -> (req, rsp, chain) -> new AuthFilter(client, profileType, (AuthStore)req.require(AuthStore.class)).handle(req, rsp, chain));
    }

    private void filter(Binder binder, String pattern, String name, Supplier<Route.Filter> filter) {
        Multibinder.newSetBinder((Binder)binder, Route.Definition.class).addBinding().toInstance((Object)new Route.Definition("*", pattern, filter.get()).name("auth(" + name + ")"));
    }
}

