/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jooby.Err;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Status;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthContext
implements WebContext {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Request req;
    private Response rsp;
    private Map<String, String[]> params;

    @Inject
    public AuthContext(Request req, Response rsp) {
        this.req = req;
        this.rsp = rsp;
        this.params = this.params(req);
    }

    public String getRequestParameter(String name) {
        String[] values = this.params.get(name);
        return values == null ? null : values[0];
    }

    public Map<String, String[]> getRequestParameters() {
        return this.params;
    }

    public String getRequestHeader(String name) {
        return this.req.header(name).toOptional().orElse(null);
    }

    public void setSessionAttribute(String name, Object value) {
        if (value == null) {
            this.req.session().unset(name);
        } else {
            this.req.session().set(name, value.toString());
        }
    }

    public Object getSessionAttribute(String name) {
        return this.req.session().get(name).toOptional().orElse(null);
    }

    public String getRequestMethod() {
        return this.req.method();
    }

    public void writeResponseContent(String content) {
        try {
            this.rsp.send((Object)content);
        }
        catch (Exception ex) {
            throw new Err(Status.SERVER_ERROR, (Throwable)ex);
        }
    }

    public void setResponseStatus(int code) {
        this.rsp.status(code);
    }

    public void setResponseHeader(String name, String value) {
        this.rsp.header(name, (Object)value);
    }

    public String getServerName() {
        return this.req.hostname();
    }

    public int getServerPort() {
        return this.req.port();
    }

    public String getScheme() {
        return this.req.secure() ? "https" : "http";
    }

    public String getFullRequestURL() {
        return this.getScheme() + "://" + this.getServerName() + ":" + this.getServerPort() + this.req.path();
    }

    private Map<String, String[]> params(Request req) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        req.params().toMap().forEach((name, value) -> {
            try {
                List values = value.toList();
                result.put(name, (Object)values.toArray(new String[values.size()]));
            }
            catch (Err ignored) {
                this.log.debug("ignoring HTTP param: " + name, (Throwable)ignored);
            }
        });
        return result.build();
    }

    public String toString() {
        return this.req.toString();
    }
}

