/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.pac4j;

import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jooby.Session;
import org.jooby.internal.pac4j.AuthSerializer;
import org.jooby.pac4j.AuthStore;
import org.pac4j.core.profile.CommonProfile;

public class AuthSessionStore<U extends CommonProfile>
implements AuthStore<U> {
    public static final String USER_PROFILE = "pac4jUserProfile";
    private Provider<Session> session;

    @Inject
    public AuthSessionStore(Provider<Session> session) {
        this.session = Objects.requireNonNull(session, "Session is required.");
    }

    @Override
    public Optional<U> get(String id) throws Exception {
        Session session = (Session)this.session.get();
        return this.get(session.get(AuthSessionStore.key(id)).toOptional());
    }

    @Override
    public void set(U profile) throws Exception {
        ((Session)this.session.get()).set(AuthSessionStore.key(profile.getId()), AuthSerializer.objToStr(profile));
    }

    @Override
    public Optional<U> unset(String id) throws Exception {
        Session session = (Session)this.session.get();
        return this.get(session.unset(AuthSessionStore.key(id)).toOptional());
    }

    private Optional<U> get(Optional<String> value) {
        CommonProfile profile = null;
        if (value.isPresent()) {
            profile = (CommonProfile)AuthSerializer.strToObject(value.get());
        }
        return Optional.ofNullable(profile);
    }

    private static String key(String property) {
        return AuthSessionStore.key(USER_PROFILE, property);
    }

    private static String key(String prefix, String property) {
        return prefix + "." + property;
    }
}

