/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jooby.Err;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;
import org.jooby.funzy.Throwing;
import org.jooby.internal.pac4j.AuthResponse;
import org.jooby.pac4j.Auth;
import org.jooby.pac4j.AuthStore;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.finder.ClientFinder;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthFilter
implements Route.Handler {
    private static final Predicate<Client> useSession = c -> c instanceof IndirectClient;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String clientName;
    private Class<? extends CommonProfile> profileType;

    public AuthFilter(Class<? extends Client<?, ?>> clientType, Class<? extends CommonProfile> profileType) {
        this.clientName = clientType.getSimpleName();
        this.profileType = Objects.requireNonNull(profileType, "ProfileType is required.");
    }

    public AuthFilter setName(String clientName) {
        this.clientName = this.clientName + "," + clientName;
        return this;
    }

    public String getName() {
        return this.clientName;
    }

    public void handle(Request req, Response rsp) throws Throwable {
        AuthStore store;
        Clients clients = (Clients)req.require(Clients.class);
        String clientName = req.param(clients.getClientNameParameter()).value(this.clientName);
        WebContext ctx = (WebContext)req.require(WebContext.class);
        ClientFinder finder = (ClientFinder)req.require(ClientFinder.class);
        CommonProfile profile = (CommonProfile)this.find(finder, clients, ctx, null, clientName, arg_0 -> this.lambda$handle$1(req, store = (AuthStore)req.require(AuthStore.class), ctx, arg_0));
        if (profile == null) {
            Boolean redirected = (Boolean)this.find(finder, clients, ctx, null, clientName, client -> {
                if (useSession.test((Client)client)) {
                    try {
                        String queryString = req.queryString().map(it -> "?" + it).orElse("");
                        String requestedUrl = req.path() + queryString;
                        this.log.debug("requestedUrl: {}", (Object)requestedUrl);
                        ctx.setSessionAttribute("pac4jRequestedUrl", (Object)requestedUrl);
                        client.redirect(ctx);
                        rsp.end();
                    }
                    catch (HttpAction ex) {
                        new AuthResponse(rsp).handle((Client<?, ?>)client, ex);
                    }
                    return Boolean.TRUE;
                }
                return null;
            });
            if (redirected != Boolean.TRUE) {
                throw new Err(Status.UNAUTHORIZED);
            }
        } else {
            this.log.debug("profile found: {}", (Object)profile);
            this.seed(req, this.profileType, profile);
        }
    }

    private String profileID(boolean useSession, Request req) {
        return req.ifGet(Auth.ID).orElseGet(() -> useSession ? req.session().get(Auth.ID).value(null) : null);
    }

    private <T> T find(ClientFinder finder, Clients clients, WebContext ctx, Class<? extends Client<?, ?>> clientType, String clientName, Throwing.Function<Client, T> fn) throws Throwable {
        List result = finder.find(clients, ctx, clientName);
        for (Client client : result) {
            Object value = fn.apply((Object)client);
            if (value == null) continue;
            return (T)value;
        }
        return null;
    }

    private void seed(Request req, Class type, Object profile) {
        while (type != Object.class) {
            req.set(type, profile);
            type = type.getSuperclass();
        }
    }

    private /* synthetic */ CommonProfile lambda$handle$1(Request req, AuthStore store, WebContext ctx, Client client) throws Throwable {
        CommonProfile identity;
        String profileId = this.profileID(useSession.test(client), req);
        CommonProfile commonProfile = identity = profileId == null ? null : (CommonProfile)store.get(profileId).orElse(null);
        if (identity == null && client instanceof DirectClient) {
            this.log.debug("Performing authentication for client: {}", (Object)client);
            try {
                Credentials credentials = client.getCredentials(ctx);
                this.log.debug("credentials: {}", (Object)credentials);
                identity = client.getUserProfile(credentials, ctx);
                this.log.debug("profile: {}", (Object)identity);
                if (identity != null) {
                    req.set(Auth.ID, (Object)identity.getId());
                    req.set(Auth.CNAME, (Object)client.getName());
                    store.set(identity);
                }
            }
            catch (HttpAction e) {
                throw new TechnicalException("Unexpected HTTP action", (Throwable)e);
            }
        }
        return identity;
    }
}

