/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.jooby.Err;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;
import org.pac4j.core.authorization.checker.AuthorizationChecker;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizerFilter
implements Route.Handler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String authorizer;

    public AuthorizerFilter(String authorizer) {
        this.authorizer = Objects.requireNonNull(authorizer, "Authorizer's name is required.");
    }

    public void handle(Request req, Response rsp) throws Exception {
        CommonProfile user = (CommonProfile)req.require(CommonProfile.class);
        Config config = (Config)req.require(Config.class);
        WebContext ctx = (WebContext)req.require(WebContext.class);
        AuthorizationChecker authorizationChecker = (AuthorizationChecker)req.require(AuthorizationChecker.class);
        Map authorizers = config.getAuthorizers();
        this.log.debug("checking access for: {}", (Object)user);
        if (!authorizationChecker.isAuthorized(ctx, Arrays.asList(user), this.authorizer, authorizers)) {
            this.log.debug("forbidden: {}", (Object)user);
            throw new Err(Status.FORBIDDEN);
        }
        this.log.debug("authorized: {}", (Object)user);
    }
}

