/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j;

import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Primitives;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jooby.funzy.Try;

public final class AuthSerializer {
    private static final String PREFIX = "b64~";

    public static final Object strToObject(String value) {
        if (value == null || !value.startsWith(PREFIX)) {
            return value;
        }
        return Try.apply(() -> {
            byte[] bytes = BaseEncoding.base64().decode((CharSequence)value.substring(PREFIX.length()));
            return new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }).wrap(x -> new IllegalArgumentException("Can't de-serialize value " + value, (Throwable)x)).get();
    }

    public static final String objToStr(Object value) {
        if (value instanceof CharSequence || Primitives.isWrapperType(value.getClass())) {
            return value.toString();
        }
        return (String)Try.apply(() -> {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(bytes);
            stream.writeObject(value);
            stream.flush();
            return PREFIX + BaseEncoding.base64().encode(bytes.toByteArray());
        }).wrap(x -> new IllegalArgumentException("Can't serialize value " + value, (Throwable)x)).get();
    }
}

