/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j2;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jooby.Cookie;
import org.jooby.Err;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.funzy.Try;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.LoggerFactory;

public class Pac4jContext
implements WebContext {
    private static final String[] NO_PARAM = new String[]{null};
    private final Map<String, String[]> params;
    private final Request req;
    private final Response rsp;
    private SessionStore sessionStore;

    @Inject
    public Pac4jContext(Request req, Response rsp, SessionStore<WebContext> sessionStore) {
        this.req = req;
        this.rsp = rsp;
        this.params = Pac4jContext.params(req);
        this.sessionStore = sessionStore;
    }

    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    @Deprecated
    public void setSessionStore(SessionStore sessionStore) {
    }

    public String getRequestParameter(String name) {
        String value = this.req.ifGet("pac4j." + name).map(Objects::toString).orElse(this.params.getOrDefault(name, NO_PARAM)[0]);
        return value;
    }

    public Map<String, String[]> getRequestParameters() {
        return this.params;
    }

    public Object getRequestAttribute(String name) {
        return this.req.ifGet(name).orElse(null);
    }

    public void setRequestAttribute(String name, Object value) {
        this.req.set(name, value);
    }

    public String getRequestHeader(String name) {
        return this.req.header(name).toOptional().orElse(null);
    }

    public void setSessionAttribute(String name, Object value) {
        this.sessionStore.set((WebContext)this, name, value);
    }

    public Object getSessionAttribute(String name) {
        return this.sessionStore.get((WebContext)this, name);
    }

    public String getSessionIdentifier() {
        return this.sessionStore.getOrCreateSessionId((WebContext)this);
    }

    public String getRequestMethod() {
        return this.req.method();
    }

    public String getRemoteAddr() {
        return this.req.ip();
    }

    public void writeResponseContent(String content) {
        Try.run(() -> this.rsp.send((Object)content));
    }

    public void setResponseStatus(int code) {
        this.rsp.status(code);
    }

    public void setResponseHeader(String name, String value) {
        this.rsp.header(name, (Object)value);
    }

    public void setResponseContentType(String content) {
        this.rsp.type(content);
    }

    public String getServerName() {
        return this.req.hostname();
    }

    public int getServerPort() {
        return this.req.port();
    }

    public String getScheme() {
        return this.req.secure() ? "https" : "http";
    }

    public boolean isSecure() {
        return this.req.secure();
    }

    public String getFullRequestURL() {
        return Pac4jContext.getFullRequestURL(this, this.req, this.getPath());
    }

    public static String getFullRequestURL(WebContext ctx, Request req, String path) {
        StringBuilder url = new StringBuilder();
        url.append(ctx.getScheme()).append("://").append(ctx.getServerName()).append(":").append(ctx.getServerPort());
        url.append(req.contextPath()).append(path);
        req.queryString().ifPresent(query -> url.append("?").append((String)query));
        return url.toString();
    }

    public Collection<Cookie> getRequestCookies() {
        return this.req.cookies().stream().map(c -> {
            Cookie cookie = new Cookie(c.name(), (String)c.value().orElse(null));
            c.domain().ifPresent(arg_0 -> ((Cookie)cookie).setDomain(arg_0));
            c.path().ifPresent(arg_0 -> ((Cookie)cookie).setPath(arg_0));
            cookie.setSecure(c.secure());
            cookie.setHttpOnly(c.httpOnly());
            return cookie;
        }).collect(Collectors.toList());
    }

    public void addResponseCookie(Cookie cookie) {
        Cookie.Definition c = new Cookie.Definition(cookie.getName(), cookie.getValue());
        Optional.ofNullable(cookie.getDomain()).ifPresent(arg_0 -> ((Cookie.Definition)c).domain(arg_0));
        Optional.ofNullable(cookie.getPath()).ifPresent(arg_0 -> ((Cookie.Definition)c).path(arg_0));
        c.httpOnly(cookie.isHttpOnly());
        c.maxAge(cookie.getMaxAge());
        c.secure(cookie.isSecure());
        this.rsp.cookie(c);
    }

    public String getPath() {
        return this.req.path();
    }

    public String getRequestContent() {
        return (String)Try.apply(() -> this.req.body().value()).get();
    }

    private static Map<String, String[]> params(Request req) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        req.params().toMap().forEach((name, value) -> {
            try {
                List values = value.toList();
                result.put(name, (Object)values.toArray(new String[values.size()]));
            }
            catch (Err ignored) {
                LoggerFactory.getLogger(Pac4jContext.class).debug("ignoring HTTP param: " + name, (Throwable)ignored);
            }
        });
        return result.build();
    }
}

