/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j2;

import java.util.Set;
import org.jooby.Err;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.internal.pac4j2.Pac4jGrantAccessAdapter;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.SecurityGrantedAccessAdapter;
import org.pac4j.core.exception.TechnicalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pac4jSecurityFilter
implements Route.Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Config conf;
    private final Set<String> excludes;
    private String clients;
    private final String matchers;
    private final boolean multiProfile;
    private String authorizers;

    public Pac4jSecurityFilter(Config conf, String clients, String authorizers, String matchers, boolean multiProfile, Set<String> excludes) {
        this.conf = conf;
        this.clients = clients;
        this.authorizers = authorizers;
        this.matchers = matchers;
        this.multiProfile = multiProfile;
        this.excludes = excludes;
    }

    public Pac4jSecurityFilter addClient(String client) {
        this.clients = this.clients + "," + client;
        return this;
    }

    public void handle(Request req, Response rsp, Route.Chain chain) throws Throwable {
        try {
            WebContext context = (WebContext)req.require(WebContext.class);
            String existingRequestedUrl = (String)context.getSessionAttribute("pac4jRequestedUrl");
            boolean resetRequestedUrl = this.excludes.stream().filter(it -> !it.endsWith("/**") && req.matches(it)).findFirst().isPresent();
            this.conf.getSecurityLogic().perform(context, this.conf, (SecurityGrantedAccessAdapter)new Pac4jGrantAccessAdapter(req, rsp, chain), this.conf.getHttpActionAdapter(), this.clients, this.authorizers, this.matchers, Boolean.valueOf(this.multiProfile), new Object[0]);
            if (resetRequestedUrl && req.ifSession().isPresent()) {
                context.setSessionAttribute("pac4jRequestedUrl", (Object)existingRequestedUrl);
            }
        }
        catch (TechnicalException x) {
            Throwable cause = x.getCause();
            if (!(cause instanceof Err)) {
                cause = x;
            }
            throw cause;
        }
    }

    public String toString() {
        return this.clients;
    }
}

