/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j2;

import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Primitives;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.inject.Inject;
import org.jooby.Request;
import org.jooby.Session;
import org.jooby.funzy.Try;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;

public class Pac4jSessionStore
implements SessionStore<WebContext> {
    private static final String PREFIX = "b64~";
    private final Request req;

    @Inject
    public Pac4jSessionStore(Request req) {
        this.req = req;
    }

    public String getOrCreateSessionId(WebContext context) {
        return this.req.session().id();
    }

    public Object get(WebContext context, String key) {
        return this.req.ifSession().map(session -> {
            String value = session.get(key).toOptional().orElse(null);
            return Pac4jSessionStore.strToObject(value);
        }).orElse(null);
    }

    public void set(WebContext context, String key, Object value) {
        if (value == null) {
            this.req.ifSession().ifPresent(session -> session.unset(key));
        } else {
            this.req.session().set(key, Pac4jSessionStore.objToStr(value));
        }
    }

    public boolean destroySession(WebContext ctx) {
        this.req.ifSession().ifPresent(Session::destroy);
        return true;
    }

    public Object getTrackableSession(WebContext ctx) {
        return this.req;
    }

    public SessionStore<WebContext> buildFromTrackableSession(WebContext ctx, Object o) {
        if (o instanceof Request) {
            return new Pac4jSessionStore(this.req);
        }
        return null;
    }

    public boolean renewSession(WebContext ctx) {
        this.req.ifSession().ifPresent(Session::renewId);
        return true;
    }

    static final Object strToObject(String value) {
        if (value == null || !value.startsWith(PREFIX)) {
            return value;
        }
        return Try.apply(() -> {
            byte[] bytes = BaseEncoding.base64().decode((CharSequence)value.substring(PREFIX.length()));
            return new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }).get();
    }

    static final String objToStr(Object value) {
        if (value instanceof CharSequence || Primitives.isWrapperType(value.getClass())) {
            return value.toString();
        }
        return PREFIX + (String)Try.apply(() -> {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(bytes);
            stream.writeObject(value);
            stream.flush();
            return BaseEncoding.base64().encode(bytes.toByteArray());
        }).get();
    }
}

