/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.pac4j;

import com.google.common.base.Strings;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.jooby.Env;
import org.jooby.Err;
import org.jooby.Jooby;
import org.jooby.Registry;
import org.jooby.Request;
import org.jooby.Route;
import org.jooby.Router;
import org.jooby.Status;
import org.jooby.funzy.Throwing;
import org.jooby.internal.pac4j2.Pac4jActionAdapter;
import org.jooby.internal.pac4j2.Pac4jAuthorizer;
import org.jooby.internal.pac4j2.Pac4jCallback;
import org.jooby.internal.pac4j2.Pac4jClientType;
import org.jooby.internal.pac4j2.Pac4jContext;
import org.jooby.internal.pac4j2.Pac4jLoginForm;
import org.jooby.internal.pac4j2.Pac4jLogout;
import org.jooby.internal.pac4j2.Pac4jProfileManager;
import org.jooby.internal.pac4j2.Pac4jSecurityFilter;
import org.jooby.internal.pac4j2.Pac4jSessionStore;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.engine.DefaultLogoutLogic;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.HttpActionAdapter;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.http.client.indirect.FormClient;
import org.pac4j.http.credentials.authenticator.test.SimpleTestUsernamePasswordAuthenticator;

public class Pac4j
implements Jooby.Module {
    static final TypeLiteral<SessionStore<WebContext>> SSTORE = new TypeLiteral<SessionStore<WebContext>>(){};
    private BiConsumer<org.pac4j.core.config.Config, Config> configurer;
    private final org.pac4j.core.config.Config pac4j = new org.pac4j.core.config.Config();
    private List<Throwing.Function3<Config, Binder, AtomicReference<Registry>, ClientConfig>> clients = new ArrayList<Throwing.Function3<Config, Binder, AtomicReference<Registry>, ClientConfig>>();
    private Function<Request, UserProfile> unauthenticated;
    private Set<Object> profileTypes = new HashSet<Object>();
    private boolean showDevLogin;
    private Boolean multiProfile;

    public Pac4j doWith(Consumer<org.pac4j.core.config.Config> configurer) {
        return this.doWith((org.pac4j.core.config.Config pac4j, Config conf) -> configurer.accept((org.pac4j.core.config.Config)pac4j));
    }

    public Pac4j doWith(BiConsumer<org.pac4j.core.config.Config, Config> configurer) {
        this.configurer = configurer;
        return this;
    }

    public <C extends Credentials, U extends CommonProfile> Pac4j client(Function<Config, Client<C, U>> client) {
        return this.clientInternal("*", client, null);
    }

    public <C extends Credentials, U extends CommonProfile> Pac4j client(String pattern, Function<Config, Client<C, U>> client) {
        return this.clientInternal(pattern, client, null);
    }

    public <C extends Credentials, U extends CommonProfile> Pac4j client(String pattern, Class<? extends Authorizer> authorizer, Function<Config, Client<C, U>> client) {
        return this.client(pattern, new Pac4jAuthorizer(authorizer), client);
    }

    public <C extends Credentials, U extends CommonProfile> Pac4j client(String pattern, Authorizer<U> authorizer, Function<Config, Client<C, U>> client) {
        return this.clientInternal(pattern, client, authorizer);
    }

    public Pac4j unauthenticated(Function<Request, UserProfile> provider) {
        this.unauthenticated = Objects.requireNonNull(provider, "Unauthenticated provider required.");
        return this;
    }

    public Pac4j unauthenticated(Supplier<UserProfile> provider) {
        Objects.requireNonNull(provider, "Unauthenticated provider required.");
        return this.unauthenticated((Request req) -> (UserProfile)provider.get());
    }

    private <C extends Credentials, U extends CommonProfile> Pac4j clientInternal(String pattern, Function<Config, Client<C, U>> provider, Authorizer<U> authorizer) {
        this.clients.add((Throwing.Function3<Config, Binder, AtomicReference<Registry>, ClientConfig>)((Throwing.Function3)(conf, binder, registry) -> {
            Client client = (Client)provider.apply((Config)conf);
            String authorizerName = null;
            if (authorizer != null) {
                authorizerName = Pac4j.authorizerName(authorizer);
                this.pac4j.addAuthorizer(authorizerName, authorizer);
            }
            Pac4jClientType.profileTypes(Pac4jClientType.clientType(client.getClass()), profile -> {
                if (this.profileTypes.add(profile)) {
                    binder.bind(profile).toProvider(Pac4j.profileProvider(registry, profile, this.unauthenticated));
                }
            });
            return new ClientConfig(pattern, authorizerName, client);
        }));
        return this;
    }

    public Pac4j multiProfile(boolean multiProfile) {
        this.multiProfile = multiProfile;
        return this;
    }

    public Pac4j form() {
        return this.form("*");
    }

    public Pac4j form(String pattern) {
        return this.clientInternal(pattern, conf -> {
            this.showDevLogin = true;
            return new FormClient("/login", (Authenticator)new SimpleTestUsernamePasswordAuthenticator());
        }, null);
    }

    public void configure(Env env, Config conf, Binder binder) throws Throwable {
        CallbackLogic callbackLogic;
        Clients clients;
        ArrayList clientList;
        String contextPath = conf.getString("application.path");
        String callbackPath = conf.getString("pac4j.callback.path");
        this.pac4j.setClients(new Clients(URI.create(conf.getString("pac4j.callback.url")).normalize().toString(), new ArrayList()));
        this.pac4j.setHttpActionAdapter((HttpActionAdapter)new Pac4jActionAdapter());
        if (this.configurer != null) {
            this.configurer.accept(this.pac4j, conf);
        }
        if ((clientList = new ArrayList((clients = this.pac4j.getClients()).getClients())).size() == 0 && this.clients.size() == 0) {
            this.form();
        }
        AtomicReference registryRef = new AtomicReference();
        List<ClientConfig> securityRoutes = this.clients.stream().map(fn -> (ClientConfig)fn.apply((Object)conf, (Object)binder, (Object)registryRef)).collect(Collectors.toList());
        securityRoutes.forEach(it -> clientList.add(((ClientConfig)it).client));
        clients.setClients(clientList);
        boolean multiProfile = Optional.ofNullable(this.multiProfile).orElse(clientList.size() > 1);
        Router router = env.router();
        binder.bind(org.pac4j.core.config.Config.class).toInstance((Object)this.pac4j);
        binder.bind(WebContext.class).to(Pac4jContext.class);
        Function<WebContext, ProfileManager> pmf = this.pac4j.getProfileManagerFactory();
        if (pmf == null) {
            pmf = ProfileManager::new;
            this.pac4j.setProfileManagerFactory(pmf);
        }
        binder.bind(ProfileManager.class).toProvider(Pac4jProfileManager.class);
        SessionStore sessionStore = this.pac4j.getSessionStore();
        if (sessionStore == null) {
            binder.bind(SSTORE).to(Pac4jSessionStore.class);
            binder.bind(SessionStore.class).to(Pac4jSessionStore.class);
        } else {
            binder.bind(SSTORE).toInstance((Object)sessionStore);
            binder.bind(SessionStore.class).toInstance((Object)sessionStore);
        }
        if (this.showDevLogin) {
            router.get("/login", (Route.Handler)new Pac4jLoginForm(Route.normalize((String)(contextPath + callbackPath)))).name("pac4j(LoginForm)");
        }
        if ((callbackLogic = this.pac4j.getCallbackLogic()) == null) {
            callbackLogic = new DefaultCallbackLogic();
            this.pac4j.setCallbackLogic(callbackLogic);
        }
        String callbackRedirectTo = Optional.ofNullable(Strings.emptyToNull((String)conf.getString("pac4j.callback.redirectTo"))).orElse(contextPath);
        boolean renewSession = conf.getBoolean("pac4j.callback.renewSession");
        List excludePaths = conf.getStringList("pac4j.excludePaths");
        router.use(conf.getString("pac4j.callback.method"), callbackPath, (Route.Handler)new Pac4jCallback(this.pac4j, callbackRedirectTo, multiProfile, renewSession)).excludes(excludePaths).name("pac4j(Callback)");
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        SecurityLogic securityLogic = this.pac4j.getSecurityLogic();
        if (securityLogic == null) {
            securityLogic = new DefaultSecurityLogic();
            this.pac4j.setSecurityLogic(securityLogic);
        }
        LinkedHashMap<String, Pac4jSecurityFilter> filters = new LinkedHashMap<String, Pac4jSecurityFilter>();
        patterns.add(callbackPath);
        securityRoutes.forEach(it -> {
            String pattern = Route.normalize((String)((ClientConfig)it).pattern);
            patterns.add(pattern);
            Pac4jSecurityFilter filter = (Pac4jSecurityFilter)filters.get(pattern);
            String clientName = ((ClientConfig)it).client.getName();
            if (filter == null) {
                filter = new Pac4jSecurityFilter(this.pac4j, clientName, ((ClientConfig)it).authorizer, null, multiProfile, patterns);
                filters.put(pattern, filter);
            } else {
                filter.addClient(clientName);
            }
        });
        filters.forEach((pattern, filter) -> {
            ArrayList excludes = new ArrayList();
            excludes.addAll(excludePaths);
            excludes.addAll(patterns);
            excludes.remove(pattern);
            excludes.remove("/**");
            router.use(conf.getString("pac4j.securityFilter.method"), pattern, (Route.Filter)filter).excludes(excludes).name("pac4j(" + filter + ")");
        });
        LogoutLogic logoutLogic = this.pac4j.getLogoutLogic();
        if (logoutLogic == null) {
            logoutLogic = new DefaultLogoutLogic();
            this.pac4j.setLogoutLogic(logoutLogic);
        }
        router.use(conf.getString("pac4j.logout.method"), conf.getString("pac4j.logout.path"), (Route.Handler)new Pac4jLogout(this.pac4j, conf.getString("pac4j.logout.redirectTo"), conf.getString("pac4j.logout.pattern"), conf.getBoolean("pac4j.logout.destroySession"), conf.getBoolean("pac4j.logout.local"), conf.getBoolean("pac4j.logout.central"))).name("pac4j(Logout)");
        env.onStart(registry -> {
            registryRef.set(registry);
            this.pac4j.getAuthorizers().values().stream().filter(Pac4jAuthorizer.class::isInstance).map(Pac4jAuthorizer.class::cast).forEach(fwd -> fwd.setRegistry((Registry)registry));
        });
        this.profileTypes.clear();
        this.profileTypes = null;
        this.clients.clear();
        this.clients = null;
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"pac4j.conf");
    }

    static String authorizerName(Object authorizer) {
        if (authorizer instanceof Pac4jAuthorizer) {
            return ((Pac4jAuthorizer)authorizer).authorizer.getSimpleName();
        }
        return authorizer.getClass().getSimpleName();
    }

    static Provider profileProvider(AtomicReference<Registry> registry, Class profile, Function<Request, UserProfile> unauthenticated) {
        return () -> {
            Request req = (Request)((Registry)registry.get()).require(Request.class);
            ProfileManager pm = (ProfileManager)req.require(ProfileManager.class);
            Object result = pm.getAll(req.ifSession().isPresent()).stream().filter(profile::isInstance).findFirst().orElse(null);
            if (result == null) {
                if (unauthenticated == null) {
                    throw new Err(Status.FORBIDDEN, "Not found: " + profile.getSimpleName());
                }
                result = unauthenticated.apply(req);
            }
            return result;
        };
    }

    private static class ClientConfig {
        private String pattern;
        private String authorizer;
        private Client client;

        public ClientConfig(String pattern, String authorizer, Client client) {
            this.pattern = pattern;
            this.authorizer = authorizer;
            this.client = client;
        }
    }
}

