/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.pebble;

import com.google.common.cache.CacheBuilder;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Renderer;
import org.jooby.pebble.PebbleRenderer;

public class Pebble
implements Jooby.Module {
    private BiConsumer<PebbleEngine.Builder, Config> callback;
    private PebbleEngine.Builder pebble;

    public Pebble(String prefix, String suffix) {
        this.pebble = new PebbleEngine.Builder().loader(Pebble.loader(prefix, suffix));
    }

    public Pebble(String suffix) {
        this(null, suffix);
    }

    public Pebble() {
        this(null, ".html");
    }

    public Pebble doWith(BiConsumer<PebbleEngine.Builder, Config> callback) {
        this.callback = Objects.requireNonNull(callback, "Callback is required.");
        return this;
    }

    public Pebble doWith(Consumer<PebbleEngine.Builder> callback) {
        Objects.requireNonNull(callback, "Callback is required.");
        return this.doWith((PebbleEngine.Builder p, Config c) -> callback.accept((PebbleEngine.Builder)p));
    }

    public void configure(Env env, Config conf, Binder binder) {
        String mode = env.name();
        if (mode.equals("dev") || conf.getString("pebble.cache").isEmpty()) {
            this.pebble.templateCache(null);
        } else {
            this.pebble.templateCache(CacheBuilder.from((String)conf.getString("pebble.cache")).build());
        }
        if (mode.equals("dev") || conf.getString("pebble.tagCache").isEmpty()) {
            this.pebble.tagCache(null);
        } else {
            this.pebble.tagCache(CacheBuilder.from((String)conf.getString("pebble.tagCache")).build());
        }
        this.pebble.defaultLocale(env.locale());
        if (this.callback != null) {
            this.callback.accept(this.pebble, conf);
        }
        PebbleEngine pebble = this.pebble.build();
        binder.bind(PebbleEngine.class).toInstance((Object)pebble);
        Multibinder.newSetBinder((Binder)binder, Renderer.class).addBinding().toInstance((Object)new PebbleRenderer(pebble));
    }

    public Config config() {
        return ConfigFactory.empty((String)Pebble.class.getName()).withValue("pebble.cache", ConfigValueFactory.fromAnyRef((Object)"maximumSize=200")).withValue("pebble.tagCache", ConfigValueFactory.fromAnyRef((Object)"maximumSize=200"));
    }

    private static Loader<String> loader(String prefix, String suffix) {
        ClasspathLoader loader = new ClasspathLoader();
        loader.setPrefix(prefix);
        loader.setSuffix(suffix);
        return loader;
    }
}

