/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.pebble;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.FileNotFoundException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jooby.MediaType;
import org.jooby.Renderer;
import org.jooby.View;

class PebbleRenderer
implements View.Engine {
    private PebbleEngine pebble;

    public PebbleRenderer(PebbleEngine pebble) {
        this.pebble = pebble;
    }

    public void render(View view, Renderer.Context ctx) throws Exception {
        String vname = view.name();
        try {
            Map locals = ctx.locals();
            if (vname.charAt(0) == '/') {
                vname = vname.substring(1);
            }
            PebbleTemplate template = this.pebble.getTemplate(vname);
            StringWriter writer = new StringWriter();
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.putAll(locals);
            model.putIfAbsent("_vname", vname);
            Locale locale = locals.getOrDefault("locale", ctx.locale());
            model.putIfAbsent("locale", locale);
            model.putAll(view.model());
            template.evaluate((Writer)writer, model, locale);
            ctx.type(MediaType.html).send(((Object)writer).toString());
        }
        catch (LoaderException x) {
            FileNotFoundException fnf = new FileNotFoundException(x.getMessage().replace("Could not find template", "").trim());
            fnf.initCause(x);
            throw fnf;
        }
    }

    public String name() {
        return "pebble";
    }

    public String toString() {
        return this.name();
    }
}

