/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.pebble;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.typesafe.config.Config;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Renderer;
import org.jooby.pebble.PebbleRenderer;
import org.jooby.pebble.XssExt;

public class Pebble
implements Jooby.Module {
    private static final int MAX_SIZE = 100;
    private BiConsumer<PebbleEngine.Builder, Config> callback;
    private PebbleEngine.Builder pebble;

    public Pebble(String prefix, String suffix) {
        this.pebble = new PebbleEngine.Builder().loader(Pebble.loader(Pebble.safePrefix(prefix), suffix));
    }

    public Pebble(String suffix) {
        this(null, suffix);
    }

    public Pebble() {
        this(null, ".html");
    }

    public Pebble doWith(BiConsumer<PebbleEngine.Builder, Config> callback) {
        this.callback = Objects.requireNonNull(callback, "Callback is required.");
        return this;
    }

    public Pebble doWith(Consumer<PebbleEngine.Builder> callback) {
        Objects.requireNonNull(callback, "Callback is required.");
        return this.doWith((PebbleEngine.Builder p, Config c) -> callback.accept((PebbleEngine.Builder)p));
    }

    public void configure(Env env, Config conf, Binder binder) {
        this.pebble.cacheActive(true);
        String mode = env.name();
        Function<String, Cache> cache = path -> {
            if (conf.hasPath(path)) {
                return CacheBuilder.from((String)conf.getString(path)).build();
            }
            return CacheBuilder.newBuilder().maximumSize("dev".equals(mode) ? 0L : 100L).build();
        };
        this.pebble.templateCache(cache.apply("pebble.cache"));
        this.pebble.tagCache(cache.apply("pebble.tagCache"));
        this.pebble.defaultLocale(env.locale());
        if (this.callback != null) {
            this.callback.accept(this.pebble, conf);
        }
        this.pebble.extension(new Extension[]{new XssExt(env)});
        PebbleEngine pebble = this.pebble.build();
        binder.bind(PebbleEngine.class).toInstance((Object)pebble);
        Multibinder.newSetBinder((Binder)binder, Renderer.class).addBinding().toInstance((Object)new PebbleRenderer(pebble));
    }

    private static Loader<String> loader(String prefix, String suffix) {
        ClasspathLoader loader = new ClasspathLoader();
        loader.setPrefix(prefix);
        loader.setSuffix(suffix);
        return loader;
    }

    private static String safePrefix(String prefix) {
        if (prefix != null && prefix.length() > 0) {
            if (prefix.startsWith("/")) {
                return Strings.emptyToNull((String)prefix.substring(1));
            }
            return prefix;
        }
        return null;
    }
}

