/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.quartz;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jooby.internal.quartz.MethodJobDetail;
import org.jooby.internal.quartz.ReflectiveJob;
import org.jooby.quartz.Scheduled;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class JobExpander {
    public static Map<JobDetail, Trigger> jobs(Config config, List<Class<?>> jobs) {
        HashMap<JobDetail, Trigger> triggers = new HashMap<JobDetail, Trigger>();
        for (Class<?> job : jobs) {
            if (Job.class.isAssignableFrom(job)) {
                triggers.put(JobExpander.job(job), JobExpander.trigger(config, job));
                continue;
            }
            Method[] methods = job.getDeclaredMethods();
            int size = triggers.size();
            for (Method method : methods) {
                Scheduled scheduled = method.getAnnotation(Scheduled.class);
                if (scheduled == null) continue;
                int mods = method.getModifiers();
                if (!Modifier.isPublic(mods)) {
                    throw new IllegalArgumentException("Job method must be public: " + method);
                }
                if (Modifier.isStatic(mods)) {
                    throw new IllegalArgumentException("Job method should NOT be public: " + method);
                }
                if (method.getParameterCount() > 0) {
                    if (method.getParameterCount() > 1) {
                        throw new IllegalArgumentException("Job method args must be ZERO/ONE: " + method);
                    }
                    if (method.getParameterTypes()[0] != JobExecutionContext.class) {
                        throw new IllegalArgumentException("Job method args isn't a " + JobExecutionContext.class.getName() + ": " + method);
                    }
                }
                triggers.put(JobExpander.job(method), JobExpander.newTrigger(config, scheduled, JobExpander.jobKey(method)));
            }
            Preconditions.checkArgument((size < triggers.size() ? 1 : 0) != 0, (String)"Scheduled is missing on %s", (Object[])new Object[]{job.getName()});
        }
        return triggers;
    }

    private static JobDetail job(Class<? extends Job> jobType) {
        JobKey key = JobExpander.jobKey(jobType);
        return JobBuilder.newJob(jobType).withIdentity(key).build();
    }

    private static JobDetail job(Method method) {
        MethodJobDetail detail = new MethodJobDetail(method);
        detail.setJobClass(ReflectiveJob.class);
        detail.setKey(JobExpander.jobKey(method));
        return detail;
    }

    private static JobKey jobKey(Class<?> jobType) {
        return JobKey.jobKey((String)jobType.getSimpleName(), (String)jobType.getPackage().getName());
    }

    private static JobKey jobKey(Method method) {
        Class<?> klass = method.getDeclaringClass();
        String classname = klass.getSimpleName();
        for (klass = klass.getDeclaringClass(); klass != null; klass = klass.getDeclaringClass()) {
            classname = klass.getSimpleName() + "$" + classname;
        }
        return JobKey.jobKey((String)(classname + "." + method.getName()), (String)method.getDeclaringClass().getPackage().getName());
    }

    private static Trigger trigger(Config config, Class<? extends Job> jobType) {
        Method execute = Arrays.stream(jobType.getDeclaredMethods()).filter(m -> m.getName().equals("execute")).findFirst().get();
        Scheduled scheduled = execute.getAnnotation(Scheduled.class);
        Preconditions.checkArgument((scheduled != null ? 1 : 0) != 0, (String)"Scheduled is missing on %s.%s()", (Object[])new Object[]{jobType.getName(), execute.getName()});
        return JobExpander.newTrigger(config, scheduled, JobExpander.jobKey(jobType));
    }

    private static Trigger newTrigger(Config config, Scheduled scheduled, JobKey key) {
        Function<String, Boolean> hasPath = p -> {
            try {
                return config.hasPath(p);
            }
            catch (ConfigException.BadPath ex) {
                return false;
            }
        };
        String expr = scheduled.value();
        Object value = hasPath.apply(expr) != false ? JobExpander.intervalOrCron(config, expr) : JobExpander.intervalOrCron(ConfigFactory.empty().withValue("expr", ConfigValueFactory.fromAnyRef((Object)expr)), "expr");
        if (value instanceof String) {
            return TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)((String)value))).withIdentity(TriggerKey.triggerKey((String)key.getName(), (String)key.getGroup())).build();
        }
        return TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(((Long)value).longValue()).repeatForever()).withIdentity(TriggerKey.triggerKey((String)key.getName(), (String)key.getGroup())).startNow().build();
    }

    private static Object intervalOrCron(Config config, String name) {
        try {
            return config.getDuration(name, TimeUnit.MILLISECONDS);
        }
        catch (ConfigException.BadValue | ConfigException.WrongType ex) {
            return config.getString(name);
        }
    }
}

