/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.quartz;

import com.google.inject.Injector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;

public class ReflectiveJob
implements Job {
    private Injector injector;

    @Inject
    public ReflectiveJob(Injector injector) {
        this.injector = Objects.requireNonNull(injector, "An injector is required.");
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDetail detail = context.getJobDetail();
        JobKey key = detail.getKey();
        try {
            String[] names = key.getName().split("\\.");
            String classname = key.getGroup() + "." + names[0];
            Class<?> loadedClass = this.getClass().getClassLoader().loadClass(classname);
            String methodname = names[1];
            Object job = this.injector.getInstance(loadedClass);
            Method method = Arrays.stream(loadedClass.getDeclaredMethods()).filter(m -> m.getName().equals(methodname)).findFirst().get();
            Object result = method.getParameterCount() == 1 ? method.invoke(job, context) : method.invoke(job, new Object[0]);
            if (method.getReturnType() != Void.TYPE) {
                context.setResult(result);
            }
        }
        catch (InvocationTargetException ex) {
            throw new JobExecutionException("Job execution resulted in error: " + key, ex.getCause());
        }
        catch (Exception ex) {
            throw new JobExecutionException("Job execution resulted in error: " + key, (Throwable)ex);
        }
    }
}

