/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.quartz;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.internal.quartz.JobExpander;
import org.jooby.internal.quartz.QuartzProvider;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class Quartz
implements Jooby.Module {
    private List<Class<?>> jobs;
    private Map<JobDetail, Trigger> jobMap = new HashMap<JobDetail, Trigger>();

    public Quartz(Class<?> ... jobs) {
        this.jobs = Lists.newArrayList((Object[])jobs);
    }

    public Quartz with(JobDetail job, Trigger trigger) {
        Objects.requireNonNull(job, "Job is required.");
        Objects.requireNonNull(trigger, "Trigger is required.");
        this.jobMap.put(job, trigger);
        return this;
    }

    public Quartz with(Class<?> jobClass) {
        this.jobs.add(jobClass);
        return this;
    }

    public Quartz with(Class<? extends Job> jobClass, BiConsumer<JobBuilder, TriggerBuilder<Trigger>> configurer) {
        Objects.requireNonNull(jobClass, "Job class is required.");
        JobBuilder job = JobBuilder.newJob(jobClass).withIdentity(JobKey.jobKey((String)jobClass.getSimpleName(), (String)jobClass.getPackage().getName()));
        TriggerBuilder trigger = TriggerBuilder.newTrigger().withIdentity(TriggerKey.triggerKey((String)jobClass.getSimpleName(), (String)jobClass.getPackage().getName()));
        configurer.accept(job, (TriggerBuilder<Trigger>)trigger);
        return this.with(job.build(), trigger.build());
    }

    public Quartz with(Class<? extends Job> jobClass, Consumer<TriggerBuilder<Trigger>> configurer) {
        Objects.requireNonNull(jobClass, "Job class is required.");
        JobBuilder job = JobBuilder.newJob(jobClass).withIdentity(JobKey.jobKey((String)jobClass.getSimpleName(), (String)jobClass.getPackage().getName()));
        TriggerBuilder trigger = TriggerBuilder.newTrigger().withIdentity(TriggerKey.triggerKey((String)jobClass.getSimpleName(), (String)jobClass.getPackage().getName()));
        configurer.accept((TriggerBuilder<Trigger>)trigger);
        return this.with(job.build(), trigger.build());
    }

    public void configure(Env env, Config config, Binder binder) {
        this.jobMap.putAll(JobExpander.jobs(config, this.jobs));
        binder.bind(Scheduler.class).toProvider(QuartzProvider.class).asEagerSingleton();
        env.lifeCycle(QuartzProvider.class);
        binder.bind((TypeLiteral)new TypeLiteral<Map<JobDetail, Trigger>>(){}).annotatedWith((Annotation)Names.named((String)"org.quartz.jobs")).toInstance(this.jobMap);
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"quartz.conf").withFallback((ConfigMergeable)ConfigFactory.parseResources(Job.class, (String)"quartz.properties"));
    }
}

