/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.quartz;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jooby.internal.quartz.QuartzConnectionProvider;
import org.quartz.CalendarIntervalTrigger;
import org.quartz.CronTrigger;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.JobStoreTX;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.DBConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzProvider
implements Provider<Scheduler> {
    public static final TypeLiteral<Provider<DataSource>> DS_TYPE = new TypeLiteral<Provider<DataSource>>(){};
    public static final String DS = "org.quartz.jobStore.dataSource";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Scheduler scheduler;
    private Set<Map.Entry<JobDetail, Trigger>> jobs;

    @Inject
    public QuartzProvider(Injector injector, Config config, @Named(value="org.quartz.jobs") Map<JobDetail, Trigger> triggers) throws Exception {
        Objects.requireNonNull(injector, "An injector is required.");
        this.scheduler = new StdSchedulerFactory(this.properties(config)).getScheduler();
        this.jobs = triggers.entrySet();
        this.scheduler.setJobFactory((bundle, sch) -> {
            JobDetail jobDetail = bundle.getJobDetail();
            Class jobClass = jobDetail.getJobClass();
            return (Job)injector.getInstance(jobClass);
        });
        if (config.hasPath(DS)) {
            String name = config.getString(DS);
            Provider ds = (Provider)injector.getInstance(Key.get(DS_TYPE, (Annotation)Names.named((String)name)));
            DBConnectionManager.getInstance().addConnectionProvider(name, (ConnectionProvider)new QuartzConnectionProvider((Provider<DataSource>)ds));
        }
    }

    @PostConstruct
    public void start() throws Exception {
        for (Map.Entry<JobDetail, Trigger> job : this.jobs) {
            JobDetail detail = job.getKey();
            Trigger trigger = job.getValue();
            this.log.info("  {} {}", (Object)detail.getKey(), this.describe(trigger));
            this.scheduler.scheduleJob(detail, trigger);
        }
        this.scheduler.start();
    }

    @PreDestroy
    public void stop() throws Exception {
        this.scheduler.shutdown();
    }

    public Scheduler get() {
        return this.scheduler;
    }

    private Properties properties(Config config) {
        String ds;
        Properties props = new Properties();
        config.getConfig("org.quartz").entrySet().forEach(e -> props.setProperty("org.quartz." + (String)e.getKey(), ((ConfigValue)e.getValue()).unwrapped().toString()));
        String store = props.getProperty("org.quartz.jobStore.class");
        if (JobStoreTX.class.getName().equals(store) && (ds = props.getProperty(DS)) == null) {
            throw new IllegalArgumentException("Missing property: org.quartz.jobStore.dataSource");
        }
        return props;
    }

    private Object describe(Trigger trigger) {
        if (trigger.getDescription() != null) {
            return trigger.getDescription();
        }
        if (trigger instanceof SimpleTrigger) {
            return "will fire every " + ((SimpleTrigger)trigger).getRepeatInterval() + "ms";
        }
        if (trigger instanceof CronTrigger) {
            return "will fire at " + ((CronTrigger)trigger).getCronExpression();
        }
        if (trigger instanceof CalendarIntervalTrigger) {
            CalendarIntervalTrigger calendar = (CalendarIntervalTrigger)trigger;
            return "will fire every " + calendar.getRepeatInterval() + " " + calendar.getRepeatIntervalUnit();
        }
        if (trigger instanceof DailyTimeIntervalTrigger) {
            DailyTimeIntervalTrigger daily = (DailyTimeIntervalTrigger)trigger;
            return "will fire every " + daily.getRepeatInterval() + " " + daily.getRepeatIntervalUnit();
        }
        return trigger;
    }
}

