/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.requery;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.util.Types;
import com.typesafe.config.Config;
import io.requery.BlockingEntityStore;
import io.requery.EntityStore;
import io.requery.TransactionListener;
import io.requery.async.CompletableEntityStore;
import io.requery.async.CompletionStageEntityStore;
import io.requery.meta.EntityModel;
import io.requery.reactivex.ReactiveEntityStore;
import io.requery.reactivex.ReactiveSupport;
import io.requery.reactor.ReactorEntityStore;
import io.requery.sql.Configuration;
import io.requery.sql.ConfigurationBuilder;
import io.requery.sql.EntityDataStore;
import io.requery.sql.EntityStateListener;
import io.requery.sql.SchemaModifier;
import io.requery.sql.StatementListener;
import io.requery.sql.TableCreationMode;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Provider;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import org.jooby.Env;
import org.jooby.Jooby;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Requery
implements Jooby.Module {
    private final EntityModel model;
    private TableCreationMode schema;
    private final Function<Configuration, EntityStore> store;
    private final Class<? extends EntityStore> storeType;
    private List<Class> states = new LinkedList<Class>();
    private List<Class> statements = new LinkedList<Class>();
    private List<Class> transactions = new LinkedList<Class>();
    private BiConsumer<Config, ConfigurationBuilder> callback;
    private Provider<DataSource> dataSource;

    private Requery(Class<? extends EntityStore> storeType, EntityModel model, Function<Configuration, EntityStore> store) {
        this.storeType = storeType;
        this.model = model;
        this.store = store;
    }

    public Requery(EntityModel model) {
        this(EntityStore.class, model, c -> new EntityDataStore(c));
    }

    public Requery doWith(BiConsumer<Config, ConfigurationBuilder> configurer) {
        this.callback = Objects.requireNonNull(configurer, "Configurer callback required.");
        return this;
    }

    public Requery doWith(Consumer<ConfigurationBuilder> configurer) {
        Objects.requireNonNull(configurer, "Configurer callback required.");
        return this.doWith((Config c, ConfigurationBuilder b) -> configurer.accept((ConfigurationBuilder)b));
    }

    public Requery dataSource(Provider<DataSource> dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource, "DataSource required.");
        return this;
    }

    public Requery schema(TableCreationMode schema) {
        this.schema = schema;
        return this;
    }

    public Requery entityStateListener(Class<? extends EntityStateListener<?>> listener) {
        this.states.add(listener);
        return this;
    }

    public Requery statementListener(Class<? extends StatementListener> listener) {
        this.statements.add(listener);
        return this;
    }

    public Requery transactionListener(Class<? extends TransactionListener> listener) {
        this.transactions.add(listener);
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) {
        AtomicReference holder = new AtomicReference();
        Provider provider = holder::get;
        Consumer<Object> bind = k -> binder.bind((Key)k).toProvider(provider);
        Env.ServiceKey keys = env.serviceKey();
        this.model.getTypes().forEach(it -> {
            Class target = it.getClassType();
            Class<?> base = target.getInterfaces()[0];
            bind.accept(Key.get((Type)Types.newParameterizedType(this.storeType, (Type[])new Type[]{base, target})));
        });
        keys.generate(this.storeType, this.model.getName(), bind);
        env.onStart(registry -> {
            DataSource ds = Optional.ofNullable(this.dataSource).map(Provider::get).orElseGet(() -> (DataSource)registry.require(DataSource.class));
            this.schema(conf, this.schema, schema -> new SchemaModifier(ds, this.model).createTables(schema));
            ConfigurationBuilder builder = new ConfigurationBuilder((CommonDataSource)ds, this.model);
            if (this.callback != null) {
                this.callback.accept(conf, builder);
            }
            this.states.forEach(t -> builder.addEntityStateListener((EntityStateListener)registry.require(t)));
            this.statements.forEach(t -> builder.addStatementListener((StatementListener)registry.require(t)));
            this.transactions.forEach(t -> builder.addTransactionListenerFactory(() -> (TransactionListener)registry.require(t)));
            Configuration configuration = builder.build();
            holder.set(this.store.apply(configuration));
        });
    }

    public static Requery reactive(EntityModel model) {
        return new Requery(ReactiveEntityStore.class, model, conf -> ReactiveSupport.toReactiveStore((BlockingEntityStore)new EntityDataStore(conf)));
    }

    public static Requery reactor(EntityModel model) {
        return new Requery(ReactorEntityStore.class, model, conf -> new ReactorEntityStore((BlockingEntityStore)new EntityDataStore(conf)));
    }

    public static Requery completionStage(EntityModel model) {
        return new Requery(CompletionStageEntityStore.class, model, conf -> new CompletableEntityStore((BlockingEntityStore)new EntityDataStore(conf)));
    }

    private void schema(Config conf, TableCreationMode schema, Consumer<TableCreationMode> callback) {
        if (schema != null) {
            callback.accept(schema);
        }
        if (conf.hasPath("requery.schema")) {
            callback.accept(TableCreationMode.valueOf((String)conf.getString("requery.schema").toUpperCase()));
        }
    }

    static {
        if (!SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
    }
}

