/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.rocker;

import com.fizzed.rocker.Rocker;
import com.fizzed.rocker.RockerModel;
import com.fizzed.rocker.runtime.ArrayOfByteArraysOutput;
import java.nio.channels.Channels;
import java.util.Map;
import org.jooby.MediaType;
import org.jooby.Renderer;
import org.jooby.Route;
import org.jooby.View;
import org.jooby.rocker.RequestRockerTemplate;

class RockerRenderer
implements Renderer {
    private String prefix;
    private String suffix;

    public RockerRenderer(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public void render(Object value, Renderer.Context ctx) throws Exception {
        Object model = value;
        if (value instanceof View) {
            View view = (View)value;
            String path = RockerRenderer.path(Route.normalize((String)(this.prefix + "/" + view.name() + this.suffix)));
            Map data = view.model();
            model = Rocker.template((String)path).bind(data);
        }
        if (model instanceof RockerModel) {
            ArrayOfByteArraysOutput output = (ArrayOfByteArraysOutput)((RockerModel)model).render(ArrayOfByteArraysOutput.FACTORY, template -> {
                if (template instanceof RequestRockerTemplate) {
                    RequestRockerTemplate rrt = (RequestRockerTemplate)template;
                    rrt.locals = ctx.locals();
                }
            });
            ctx.type(MediaType.html).length((long)output.getByteLength()).send(Channels.newInputStream(output.asReadableByteChannel()));
        }
    }

    static String path(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }
}

