/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.sass;

import com.vaadin.sass.internal.handler.SCSSErrorHandler;
import org.jooby.Err;
import org.jooby.Status;
import org.slf4j.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;

public class SassErrHandler
extends SCSSErrorHandler {
    private CSSParseException err;
    private Logger log;

    public SassErrHandler(Logger log) {
        this.log = log;
    }

    public void warning(CSSParseException err) throws CSSException {
        this.log.warn("{}:{}:{}\n\t{}", new Object[]{err.getURI(), err.getLineNumber(), err.getColumnNumber(), err.getMessage()});
    }

    public void error(CSSParseException err) throws CSSException {
        this.err = err;
    }

    public void fatalError(CSSParseException err) throws CSSException {
        this.err = err;
    }

    public void validate() {
        if (this.err != null) {
            String header = this.err.getURI() + ":" + this.err.getLineNumber() + ":" + this.err.getColumnNumber();
            throw new Err(Status.SERVER_ERROR, header + ": " + this.err.getMessage());
        }
    }

    static {
        if (!SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
    }
}

