/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.sass;

import com.vaadin.sass.internal.ScssStylesheet;
import com.vaadin.sass.internal.handler.SCSSDocumentHandler;
import com.vaadin.sass.internal.handler.SCSSDocumentHandlerImpl;
import com.vaadin.sass.internal.handler.SCSSErrorHandler;
import com.vaadin.sass.internal.resolver.ClassloaderResolver;
import com.vaadin.sass.internal.resolver.FilesystemResolver;
import com.vaadin.sass.internal.resolver.ScssStylesheetResolver;
import java.net.URL;
import org.jooby.Asset;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Results;
import org.jooby.handlers.AssetHandler;
import org.jooby.internal.sass.FileNotFoundResolver;
import org.jooby.internal.sass.SassErrHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SassHandler
extends AssetHandler {
    private static final String JAR_ENTRY = "!/";
    private static final String FILE = "file:";
    private static final String SASS_EXT = ".scss";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public SassHandler(String pattern) {
        super(pattern);
    }

    public SassHandler() {
        this("/");
    }

    protected URL resolve(String path) throws Exception {
        return super.resolve(path.replace(".css", SASS_EXT));
    }

    protected void send(Request req, Response rsp, Asset asset) throws Exception {
        String css = this.scss(asset).printState();
        rsp.type(asset.type()).send(Results.ok((Object)css));
    }

    private ScssStylesheet scss(Asset asset) throws Exception {
        int entry;
        String resource = asset.resource().toExternalForm();
        if (resource.startsWith(FILE)) {
            resource = resource.substring(FILE.length());
        }
        if ((entry = resource.indexOf(JAR_ENTRY)) >= 0) {
            resource = resource.substring(entry + 2);
        }
        FileNotFoundResolver fnfResolver = new FileNotFoundResolver();
        SassErrHandler errHandler = new SassErrHandler(this.log);
        ScssStylesheet root = new ScssStylesheet();
        root.addResolver((ScssStylesheetResolver)new FilesystemResolver(new String[0]));
        root.addResolver((ScssStylesheetResolver)new ClassloaderResolver());
        root.addResolver((ScssStylesheetResolver)fnfResolver);
        ScssStylesheet scss = ScssStylesheet.get((String)resource, null, (SCSSDocumentHandler)new SCSSDocumentHandlerImpl(root), (SCSSErrorHandler)errHandler);
        fnfResolver.validate(scss);
        scss.compile();
        fnfResolver.validate(scss);
        errHandler.validate();
        return scss;
    }
}

