/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.sitemap;

import cz.jiripinkas.jsitemapgenerator.WebPage;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javaslang.Function1;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Results;
import org.jooby.Route;
import org.jooby.sitemap.WebPageProvider;

class SitemapHandler
implements Route.OneArgHandler {
    private String name;
    private Predicate<Route.Definition> filter;
    private Function1<List<WebPage>, String> gen;

    public SitemapHandler(String name, Predicate<Route.Definition> filter, Function1<List<WebPage>, String> gen) {
        this.name = name;
        this.filter = filter;
        this.gen = gen;
    }

    public Object handle(Request req) throws Throwable {
        Set routes = (Set)req.require(Route.KEY);
        WebPageProvider provider = (WebPageProvider)req.require(this.name, WebPageProvider.class);
        List pages = routes.stream().filter(this.filter).flatMap(r -> provider.apply((Route.Definition)r).stream()).map(page -> {
            String name = page.getName();
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            page.setName(name);
            return page;
        }).collect(Collectors.toList());
        return Results.ok((Object)this.gen.apply(pages)).type(MediaType.xml);
    }
}

