/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.sitemap;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Route;
import org.jooby.funzy.Throwing;
import org.jooby.internal.sitemap.SitemapHandler;
import org.jooby.sitemap.WebPageProvider;

public abstract class JSitemap<T extends JSitemap>
implements Jooby.Module {
    protected static final String SITEMAP = "/sitemap.xml";
    static final Predicate<Route.Definition> NOT_ME = r -> !r.pattern().equals(SITEMAP);
    static final Predicate<Route.Definition> GET = r -> r.method().equals("GET");
    private static final String SITEMAP_BASEURL = "sitemap.url";
    private String path;
    private Consumer<Binder> wpp;
    private Predicate<Route.Definition> filter = GET;
    private Optional<String> baseurl;

    public JSitemap(String path, Optional<String> baseurl, WebPageProvider wpp) {
        this.path = path;
        this.baseurl = baseurl;
        this.wpp = binder -> binder.bind(Key.get(WebPageProvider.class, (Annotation)Names.named((String)path))).toInstance((Object)wpp);
    }

    public T filter(Predicate<Route.Definition> filter) {
        this.filter = Objects.requireNonNull(filter, "Filter is required.");
        return (T)this;
    }

    public T with(WebPageProvider wpp) {
        Objects.requireNonNull(wpp, "WebPageProvider is required.");
        this.wpp = binder -> binder.bind(Key.get(WebPageProvider.class, (Annotation)Names.named((String)this.path))).toInstance((Object)wpp);
        return (T)this;
    }

    public T with(Class<? extends WebPageProvider> wpp) {
        Objects.requireNonNull(wpp, "WebPageProvider is required.");
        this.wpp = binder -> binder.bind(Key.get(WebPageProvider.class, (Annotation)Names.named((String)this.path))).to(wpp);
        return (T)this;
    }

    public void configure(Env env, Config conf, Binder binder) {
        String baseurl = this.baseurl.orElseGet(() -> {
            if (conf.hasPath(SITEMAP_BASEURL)) {
                return conf.getString(SITEMAP_BASEURL);
            }
            Config $ = conf.getConfig("application");
            return "http://" + $.getString("host") + ":" + $.getString("port") + $.getString("path");
        });
        this.wpp.accept(binder);
        env.router().get(this.path, (Route.OneArgHandler)new SitemapHandler(this.path, NOT_ME.and(this.filter), this.gen(baseurl)));
    }

    protected abstract Throwing.Function<List<WebPage>, String> gen(String var1);
}

