/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.whoops;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javaslang.control.Try;

interface SourceLocator {
    public static SourceLocator local() {
        return SourceLocator.local(new File(System.getProperty("user.dir")).toPath());
    }

    public static SourceLocator local(Path path) {
        return filename -> (Source)Try.of(() -> {
            List<String> files = Arrays.asList(filename, filename.replace(".", File.separator) + ".java");
            Path source = Files.walk(path, new FileVisitOption[0]).filter(p -> files.stream().filter(f -> p.endsWith((String)f)).findFirst().isPresent()).findFirst().orElse(Paths.get(filename, new String[0])).toAbsolutePath();
            File file = source.toFile();
            List<String> lines = file.exists() ? Files.readAllLines(source, StandardCharsets.UTF_8) : Collections.emptyList();
            return new Source(source, lines);
        }).getOrElse((Object)new Source(path, Collections.emptyList()));
    }

    public Source source(String var1);

    public static class Source {
        private static final int[] RANGE = new int[]{0, 0};
        private final Path path;
        private final List<String> lines;

        public Source(Path path, List<String> lines) {
            this.path = path;
            this.lines = lines;
        }

        public Path getPath() {
            return this.path;
        }

        public List<String> getLines() {
            return this.lines;
        }

        public int[] range(int line, int size) {
            if (line < this.lines.size()) {
                int from = Math.max(line - size, 0);
                int toset = Math.max(line - from - size, 0);
                int to = Math.min(from + toset + size * 2, this.lines.size());
                int fromset = Math.abs(to - line - size);
                from = Math.max(from - fromset, 0);
                return new int[]{from, to};
            }
            return RANGE;
        }

        public String source(int from, int to) {
            if (from >= 0 && to <= this.lines.size()) {
                return this.lines.subList(from, to).stream().map(l -> l.length() == 0 ? " " : l).collect(Collectors.joining("\n"));
            }
            return "";
        }

        public String toString() {
            return this.path.toString();
        }
    }
}

