/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.whoops;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javaslang.Lazy;
import javaslang.control.Try;
import org.jooby.Env;
import org.jooby.Err;
import org.jooby.Jooby;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Route;
import org.jooby.Session;
import org.jooby.internal.pebble.;
import org.jooby.internal.pebble.loader.;
import org.jooby.internal.pebble.template.;
import org.jooby.whoops.SourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Whoops
implements Jooby.Module {
    private static final String HANDLER = "org.jooby.internal.HttpHandlerImpl";
    private static int SAMPLE_SIZE = 10;
    private static BiFunction<Path, Integer, String> openWith = (p, l) -> "";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void configure(Env env, Config conf, Binder binder) {
        boolean whoops;
        boolean bl = whoops = conf.hasPath("whoops.enabled") ? conf.getBoolean("whoops.enabled") : "dev".equals(env.name());
        if (whoops) {
            ClassLoader loader = env.routes().getClass().getClassLoader();
            Err.Handler handler = Whoops.prettyPage(loader, SourceLocator.local(), this.log);
            env.routes().err(Whoops.tryPage(handler, this.log));
        }
    }

    static Err.Handler tryPage(Err.Handler handler, Logger log) {
        return (req, rsp, ex) -> Try.run(() -> handler.handle(req, rsp, ex)).onFailure(cause -> log.debug("execution of pretty err page resulted in exception", cause));
    }

    private static Err.Handler prettyPage(ClassLoader loader, SourceLocator locator, Logger log) {
        String css = Whoops.readString(loader, "css/whoops.base.css");
        String clipboard = Whoops.readString(loader, "js/clipboard.min.js");
        String js = Whoops.readString(loader, "js/whoops.base.js");
        String zepto = Whoops.readString(loader, "js/zepto.min.js");
        .ClasspathLoader cpathloader = new .ClasspathLoader();
        cpathloader.setPrefix("whoops");
        cpathloader.setSuffix(".html");
        .PebbleEngine engine = new .PebbleEngine.Builder().loader((.Loader)cpathloader).cacheActive(false).build();
        Lazy template = Lazy.of(() -> (.PebbleTemplate)Try.of(() -> engine.getTemplate("layout")).get());
        return (req, rsp, err) -> {
            if (req.accepts(new MediaType[]{MediaType.html}).isPresent()) {
                Throwable cause = Optional.ofNullable(err.getCause()).orElse((Throwable)err);
                List causal = Throwables.getCausalChain((Throwable)cause);
                Throwable head = (Throwable)causal.get(causal.size() - 1);
                String message = Optional.ofNullable(head.getMessage()).orElse("");
                LinkedHashMap<String, Map<String, String>> envdata = new LinkedHashMap<String, Map<String, String>>();
                envdata.put("response", Whoops.dump(() -> ImmutableMap.of((Object)"status", rsp.status().get())));
                envdata.put("route", Whoops.dump(() -> {
                    Route route = req.route();
                    ImmutableMap.Builder map = ImmutableMap.builder();
                    return map.put((Object)"method", (Object)route.method()).put((Object)"path", (Object)route.path()).put((Object)"path vars", (Object)route.vars()).put((Object)"pattern", (Object)route.pattern()).put((Object)"name", (Object)route.name()).put((Object)"attributes", (Object)route.attributes()).build();
                }));
                envdata.put("request params", Whoops.dump(() -> req.params().toMap()));
                envdata.put("request locals", Whoops.dump(() -> ((Request)req).attributes()));
                envdata.put("request headers", Whoops.dump(() -> ((Request)req).headers()));
                req.ifSession().ifPresent(s -> envdata.put("session", Whoops.dump(() -> ((Session)s).attributes())));
                List frames = causal.stream().filter(it -> it != head).map(it -> Whoops.frame(loader, locator, it, it.getStackTrace()[0])).collect(Collectors.toList());
                frames.addAll(Whoops.frames(loader, locator, head));
                ImmutableMap context = ImmutableMap.builder().put((Object)"stylesheet", (Object)css).put((Object)"zepto", (Object)zepto).put((Object)"clipboard", (Object)clipboard).put((Object)"javascript", (Object)js).put((Object)"chain", (Object)causal).put((Object)"q", (Object)(head.getClass().getName() + ": " + message)).put((Object)"message", (Object)message).put((Object)"stacktrace", (Object)Throwables.getStackTraceAsString((Throwable)cause)).put((Object)"frames", frames).put((Object)"env", envdata).build();
                StringWriter writer = new StringWriter();
                ((.PebbleTemplate)template.get()).evaluate((Writer)writer, (Map)context);
                log.error("execution of: {}{} resulted in exception\nRoute:\n{}\n\nStacktrace:", new Object[]{req.method(), req.path(), req.route().print(6), err});
                rsp.send((Object)((Object)writer).toString());
            }
        };
    }

    private static <T> Map<String, String> dump(Supplier<Map<String, T>> hash) {
        return Whoops.dump(hash, v -> v.toString());
    }

    private static <T> Map<String, String> dump(Supplier<Map<String, T>> hash, Function<T, String> map) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        hash.get().forEach((n, v) -> {
            String cfr_ignored_0 = (String)data.put((String)n, (String)map.apply(v));
        });
        return data;
    }

    static String readString(ClassLoader loader, String path) {
        return (String)Try.of(() -> {
            String string;
            InputStream stream = null;
            try {
                stream = loader.getResourceAsStream("whoops/" + path);
                string = new String(ByteStreams.toByteArray((InputStream)stream), StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
            Closeables.closeQuietly((InputStream)stream);
            return string;
        }).get();
    }

    static List<Map<String, Object>> frames(ClassLoader loader, SourceLocator locator, Throwable cause) {
        List<StackTraceElement> stacktrace = Arrays.asList(cause.getStackTrace());
        int limit = IntStream.range(0, stacktrace.size()).filter(i -> ((StackTraceElement)stacktrace.get(i)).getClassName().equals(HANDLER)).findFirst().orElse(stacktrace.size());
        return stacktrace.stream().limit(limit).map(e -> Whoops.frame(loader, locator, cause, e)).collect(Collectors.toList());
    }

    static Map<String, Object> frame(ClassLoader loader, SourceLocator locator, Throwable cause, StackTraceElement e) {
        int line = Math.max(e.getLineNumber(), 1);
        String className = e.getClassName();
        SourceLocator.Source source = locator.source(className);
        int[] range = source.range(line, SAMPLE_SIZE);
        int lineStart = range[0];
        int lineNth = line - lineStart;
        Path filePath = source.getPath();
        Optional<Class> clazz = Whoops.findClass(loader, className);
        return ImmutableMap.builder().put((Object)"fileName", (Object)Optional.ofNullable(e.getFileName()).orElse("~unknown")).put((Object)"methodName", (Object)Optional.ofNullable(e.getMethodName()).orElse("~unknown")).put((Object)"lineNumber", (Object)line).put((Object)"lineStart", (Object)(lineStart + 1)).put((Object)"lineNth", (Object)lineNth).put((Object)"location", (Object)clazz.map(Whoops::locationOf).orElse("~unknown")).put((Object)"source", (Object)source.source(range[0], range[1])).put((Object)"open", (Object)openWith.apply(filePath, line)).put((Object)"type", (Object)clazz.map(c -> c.getSimpleName()).orElse("~unknown")).put((Object)"comments", Arrays.asList(ImmutableMap.of((Object)"context", (Object)cause.getClass().getName(), (Object)"text", (Object)Optional.ofNullable(cause.getMessage()).map(m -> ": " + m).orElse("")))).build();
    }

    static String locationOf(Class clazz) {
        return Optional.ofNullable(clazz.getResource(clazz.getSimpleName() + ".class")).map(url -> (String)Try.of(() -> {
            String path = url.getPath();
            int i = path.indexOf("!");
            if (i > 0) {
                String jar = path.substring(0, i);
                return jar.substring(Math.max(jar.lastIndexOf(47), -1) + 1);
            }
            String cfile = clazz.getName().replace(".", "/") + ".class";
            String relativePath = path.replace(cfile, "");
            return new File(System.getProperty("user.dir")).toPath().relativize(Paths.get(relativePath, new String[0])).toString();
        }).getOrElse((Object)"~unknown")).orElse("~unknown");
    }

    static Optional<Class> findClass(ClassLoader loader, String name) {
        return Arrays.asList(loader, Thread.currentThread().getContextClassLoader()).stream().map(cl -> (Class)Try.of(() -> cl.loadClass(name)).getOrElse((Object)null)).filter(Objects::nonNull).findFirst();
    }
}

