/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pebble.pebble.extension.core;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooby.internal.pebble.pebble.extension.$Function;

public class $RangeFunction
implements $Function {
    public static final String FUNCTION_NAME = "range";
    private static final String PARAM_END = "end";
    private static final String PARAM_INCREMENT = "increment";
    private static final String PARAM_START = "start";
    private final List<String> argumentNames = new ArrayList<String>();

    public $RangeFunction() {
        this.argumentNames.add(PARAM_START);
        this.argumentNames.add(PARAM_END);
        this.argumentNames.add(PARAM_INCREMENT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(Map<String, Object> args) {
        Object start = args.get(PARAM_START);
        Object end = args.get(PARAM_END);
        Object increment = args.get(PARAM_INCREMENT);
        if (increment == null) {
            increment = 1L;
        } else if (!(increment instanceof Number)) {
            throw new IllegalArgumentException("The increment of the range function must be a number " + increment);
        }
        Long incrementNum = ((Number)increment).longValue();
        ArrayList<Constable> results = new ArrayList<Constable>();
        if (start instanceof Number && end instanceof Number) {
            Long startNum = ((Number)start).longValue();
            Long endNum = ((Number)end).longValue();
            if (incrementNum > 0L) {
                Long i = startNum;
                while (i <= endNum) {
                    results.add(i);
                    i = i + incrementNum;
                }
                return results;
            } else {
                if (incrementNum >= 0L) throw new IllegalArgumentException("The increment of the range function must be different than 0");
                Long i = startNum;
                while (i >= endNum) {
                    results.add(i);
                    i = i + incrementNum;
                }
            }
            return results;
        } else {
            if (!(start instanceof String) || !(end instanceof String)) throw new IllegalArgumentException("Arguments of range function must be of type Number or String with a length of 1");
            String startStr = (String)start;
            String endStr = (String)end;
            if (startStr.length() != 1 || endStr.length() != 1) {
                throw new IllegalArgumentException("Arguments of range function must be of type Number or String with a length of 1");
            }
            int startChar = startStr.charAt(0);
            char endChar = endStr.charAt(0);
            if (incrementNum > 0L) {
                int i = startChar;
                while (i <= endChar) {
                    results.add(Character.valueOf((char)i));
                    i = (int)((long)i + incrementNum);
                }
                return results;
            } else {
                if (incrementNum >= 0L) throw new IllegalArgumentException("The increment of the range function must be different than 0");
                int i = startChar;
                while (i >= endChar) {
                    results.add(Character.valueOf((char)i));
                    i = (int)((long)i + incrementNum);
                }
            }
        }
        return results;
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }
}

