/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.whoops;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jooby.funzy.Try;

interface SourceLocator {
    public static SourceLocator local() {
        return SourceLocator.local(new File(System.getProperty("user.dir")).toPath());
    }

    public static SourceLocator local(Path path) {
        final Path bin = path.resolve("bin");
        final Path target = path.resolve("target");
        return filename -> (Source)Try.apply(() -> {
            final List<String> files = Arrays.asList(filename, filename.replace(".", File.separator) + ".java");
            final ArrayList source = Lists.newArrayList((Iterable)Paths.get(filename, new String[0]));
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.toFile().isHidden()) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (dir.equals(bin) || dir.equals(target)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return files.stream().filter(f -> file.toString().endsWith((String)f)).findFirst().map(f -> {
                        source.add(0, file.toAbsolutePath());
                        return FileVisitResult.TERMINATE;
                    }).orElse(FileVisitResult.CONTINUE);
                }
            });
            return new Source((Path)source.get(0), Files.readAllLines((Path)source.get(0), StandardCharsets.UTF_8));
        }).orElse((Object)new Source(Paths.get(filename, new String[0]), Collections.emptyList()));
    }

    public Source source(String var1);

    public static class Source {
        private static final int[] RANGE = new int[]{0, 0};
        private final Path path;
        private final List<String> lines;

        public Source(Path path, List<String> lines) {
            this.path = path;
            this.lines = lines;
        }

        public Path getPath() {
            return this.path;
        }

        public List<String> getLines() {
            return this.lines;
        }

        public int[] range(int line, int size) {
            if (line < this.lines.size()) {
                int from = Math.max(line - size, 0);
                int toset = Math.max(line - from - size, 0);
                int to = Math.min(from + toset + size * 2, this.lines.size());
                int fromset = Math.abs(to - line - size);
                from = Math.max(from - fromset, 0);
                return new int[]{from, to};
            }
            return RANGE;
        }

        public String source(int from, int to) {
            if (from >= 0 && to <= this.lines.size()) {
                return this.lines.subList(from, to).stream().map(l -> l.length() == 0 ? " " : l).collect(Collectors.joining("\n"));
            }
            return "";
        }

        public String toString() {
            return this.path.toString();
        }
    }
}

