/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.extension.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooby.internal.whoops.pebble.extension.Filter;

public class MergeFilter
implements Filter {
    public static final String FILTER_NAME = "merge";
    private final List<String> argumentNames = new ArrayList<String>();

    public MergeFilter() {
        this.argumentNames.add("items");
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object input, Map<String, Object> args) {
        Object items = args.get("items");
        if (input == null && items == null) {
            throw new IllegalArgumentException("The two arguments to be merged are null");
        }
        if (input != null && items == null) {
            return input;
        }
        if (items != null && input == null) {
            return items;
        }
        if (input instanceof Map) {
            return this.mergeAsMap((Map)input, items);
        }
        if (input instanceof List) {
            return this.mergeAsList((List)input, items);
        }
        if (input.getClass().isArray()) {
            return this.mergeAsArray(input, items);
        }
        throw new IllegalArgumentException("The object being filtered is not a Map/List/Array");
    }

    private Object mergeAsMap(Map<?, ?> arg1, Object arg2) {
        Map<?, ?> collection1 = arg1;
        HashMap<Object, Object> output = null;
        if (arg2 instanceof Map) {
            Map collection2 = (Map)arg2;
            output = new HashMap<Object, Object>(collection1.size() + collection2.size() + 16);
            output.putAll(collection1);
            output.putAll(collection2);
        } else if (arg2 instanceof List) {
            List collection2 = (List)arg2;
            output = new HashMap(collection1.size() + collection2.size() + 16);
            output.putAll(collection1);
            for (Object o : collection2) {
                output.put(o, o);
            }
        } else {
            throw new UnsupportedOperationException("Currently, only Maps and Lists can be merged with a Map. Arg2: " + arg2.getClass().getName());
        }
        return output;
    }

    private Object mergeAsList(List<?> arg1, Object arg2) {
        List<?> collection1 = arg1;
        ArrayList<Object> output = null;
        if (arg2 instanceof Map) {
            Map collection2 = (Map)arg2;
            output = new ArrayList<Object>(collection1.size() + collection2.size() + 16);
            output.addAll(collection1);
            output.addAll(collection2.entrySet());
        } else if (arg2 instanceof List) {
            List collection2 = (List)arg2;
            output = new ArrayList(collection1.size() + collection2.size() + 16);
            output.addAll(collection1);
            output.addAll(collection2);
        } else {
            throw new UnsupportedOperationException("Currently, only Maps and Lists can be merged with a List. Arg2: " + arg2.getClass().getName());
        }
        return output;
    }

    private Object mergeAsArray(Object arg1, Object arg2) {
        Class<?> arg2Class;
        Class<?> arg1Class = arg1.getClass().getComponentType();
        if (!arg1Class.equals(arg2Class = arg2.getClass().getComponentType())) {
            throw new UnsupportedOperationException("Currently, only Arrays of the same component class can be merged. Arg1: " + arg1Class.getName() + ", Arg2: " + arg2Class.getName());
        }
        Object output = Array.newInstance(arg1Class, Array.getLength(arg1) + Array.getLength(arg2));
        System.arraycopy(arg1, 0, output, 0, Array.getLength(arg1));
        System.arraycopy(arg2, 0, output, Array.getLength(arg1), Array.getLength(arg2));
        return output;
    }
}

