/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.extension.escaper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooby.internal.whoops.coverity.security.Escape;
import org.jooby.internal.whoops.pebble.extension.Filter;
import org.jooby.internal.whoops.pebble.extension.escaper.EscapingStrategy;
import org.jooby.internal.whoops.pebble.extension.escaper.SafeString;
import org.jooby.internal.whoops.pebble.utils.StringUtils;

public class EscapeFilter
implements Filter {
    private String defaultStrategy = "html";
    private final List<String> argumentNames = new ArrayList<String>();
    private final Map<String, EscapingStrategy> strategies = new HashMap<String, EscapingStrategy>();

    public EscapeFilter() {
        this.buildDefaultStrategies();
        this.argumentNames.add("strategy");
    }

    private void buildDefaultStrategies() {
        this.strategies.put("html", new EscapingStrategy(){

            @Override
            public String escape(String input) {
                return Escape.htmlText(input);
            }
        });
        this.strategies.put("js", new EscapingStrategy(){

            @Override
            public String escape(String input) {
                return Escape.jsString(input);
            }
        });
        this.strategies.put("css", new EscapingStrategy(){

            @Override
            public String escape(String input) {
                return Escape.cssString(input);
            }
        });
        this.strategies.put("html_attr", new EscapingStrategy(){

            @Override
            public String escape(String input) {
                return Escape.html(input);
            }
        });
        this.strategies.put("url_param", new EscapingStrategy(){

            @Override
            public String escape(String input) {
                return Escape.uriParam(input);
            }
        });
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object inputObject, Map<String, Object> args) {
        if (inputObject == null || inputObject instanceof SafeString) {
            return inputObject;
        }
        String input = StringUtils.toString(inputObject);
        String strategy = this.defaultStrategy;
        if (args.get("strategy") != null) {
            strategy = (String)args.get("strategy");
        }
        if (!this.strategies.containsKey(strategy)) {
            throw new RuntimeException(String.format("Unknown escaping strategy [%s]", strategy));
        }
        return new SafeString(this.strategies.get(strategy).escape(input));
    }

    public String getDefaultStrategy() {
        return this.defaultStrategy;
    }

    public void setDefaultStrategy(String defaultStrategy) {
        this.defaultStrategy = defaultStrategy;
    }

    public void addEscapingStrategy(String name, EscapingStrategy strategy) {
        this.strategies.put(name, strategy);
    }
}

