/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.lexer;

import java.util.ArrayList;
import java.util.Collection;
import org.jooby.internal.whoops.pebble.error.ParserException;
import org.jooby.internal.whoops.pebble.lexer.Token;

public class TokenStream {
    private ArrayList<Token> tokens = new ArrayList();
    private int current;
    private String filename;

    public TokenStream(Collection<Token> tokens, String name) {
        this.tokens.addAll(tokens);
        this.current = 0;
        this.filename = name;
    }

    public Token next() {
        return this.tokens.get(++this.current);
    }

    public Token expect(Token.Type type) throws ParserException {
        return this.expect(type, null);
    }

    public Token expect(Token.Type type, String value) throws ParserException {
        Token token = this.tokens.get(this.current);
        boolean success = true;
        String message = null;
        success = value == null ? token.test(type) : token.test(type, value);
        if (!success) {
            if (message == null) {
                message = String.format("Unexpected token of value \"%s\" and type %s, expected token of type %s", new Object[]{token.getValue(), token.getType().toString(), type});
            }
            throw new ParserException(null, message, token.getLineNumber(), this.filename);
        }
        this.next();
        return token;
    }

    public Token peek() {
        return this.peek(1);
    }

    public Token peek(int number) {
        return this.tokens.get(this.current + number);
    }

    public boolean isEOF() {
        return this.tokens.get(this.current).getType().equals((Object)Token.Type.EOF);
    }

    public String toString() {
        return this.tokens.toString();
    }

    public Token current() {
        return this.tokens.get(this.current);
    }

    public String getFilename() {
        return this.filename;
    }

    public ArrayList<Token> getTokens() {
        return this.tokens;
    }
}

