/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.node.expression;

import java.io.IOException;
import java.io.StringWriter;
import org.jooby.internal.whoops.pebble.error.PebbleException;
import org.jooby.internal.whoops.pebble.extension.NodeVisitor;
import org.jooby.internal.whoops.pebble.node.expression.Expression;
import org.jooby.internal.whoops.pebble.template.EvaluationContext;
import org.jooby.internal.whoops.pebble.template.Hierarchy;
import org.jooby.internal.whoops.pebble.template.PebbleTemplateImpl;

public class ParentFunctionExpression
implements Expression<String> {
    private final String blockName;
    private final int lineNumber;

    public ParentFunctionExpression(String blockName, int lineNumber) {
        this.blockName = blockName;
        this.lineNumber = lineNumber;
    }

    @Override
    public String evaluate(PebbleTemplateImpl self, EvaluationContext context) throws PebbleException {
        StringWriter writer = new StringWriter();
        try {
            Hierarchy hierarchy = context.getHierarchy();
            if (hierarchy.getParent() == null) {
                throw new PebbleException(null, "Can not use parent function if template does not extend another template.", this.lineNumber, self.getName());
            }
            PebbleTemplateImpl parent = hierarchy.getParent();
            hierarchy.ascend();
            parent.block(writer, context, this.blockName, true);
            hierarchy.descend();
        }
        catch (IOException e) {
            throw new PebbleException(e, "Could not render block [" + this.blockName + "]", this.getLineNumber(), self.getName());
        }
        return ((Object)writer).toString();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }
}

