/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.tokenParser;

import java.util.ArrayList;
import org.jooby.internal.whoops.pebble.error.ParserException;
import org.jooby.internal.whoops.pebble.lexer.Token;
import org.jooby.internal.whoops.pebble.lexer.TokenStream;
import org.jooby.internal.whoops.pebble.node.BodyNode;
import org.jooby.internal.whoops.pebble.node.PrintNode;
import org.jooby.internal.whoops.pebble.node.RenderableNode;
import org.jooby.internal.whoops.pebble.node.expression.Expression;
import org.jooby.internal.whoops.pebble.node.expression.FilterExpression;
import org.jooby.internal.whoops.pebble.node.expression.FilterInvocationExpression;
import org.jooby.internal.whoops.pebble.node.expression.RenderableNodeExpression;
import org.jooby.internal.whoops.pebble.parser.Parser;
import org.jooby.internal.whoops.pebble.parser.StoppingCondition;
import org.jooby.internal.whoops.pebble.tokenParser.AbstractTokenParser;

public class FilterTokenParser
extends AbstractTokenParser {
    private StoppingCondition endFilter = new StoppingCondition(){

        @Override
        public boolean evaluate(Token token) {
            return token.test(Token.Type.NAME, "endfilter");
        }
    };

    @Override
    public RenderableNode parse(Token token, Parser parser) throws ParserException {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        ArrayList<FilterInvocationExpression> filterInvocationExpressions = new ArrayList<FilterInvocationExpression>();
        filterInvocationExpressions.add(parser.getExpressionParser().parseFilterInvocationExpression());
        while (stream.current().test(Token.Type.OPERATOR, "|")) {
            stream.next();
            filterInvocationExpressions.add(parser.getExpressionParser().parseFilterInvocationExpression());
        }
        stream.expect(Token.Type.EXECUTE_END);
        BodyNode body = parser.subparse(this.endFilter);
        stream.next();
        stream.expect(Token.Type.EXECUTE_END);
        Expression<Object> lastExpression = new RenderableNodeExpression(body, stream.current().getLineNumber());
        for (Expression expression : filterInvocationExpressions) {
            FilterExpression filterExpression = new FilterExpression();
            filterExpression.setRight(expression);
            filterExpression.setLeft(lastExpression);
            lastExpression = filterExpression;
        }
        return new PrintNode(lastExpression, lineNumber);
    }

    @Override
    public String getTag() {
        return "filter";
    }
}

