/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.tokenParser;

import org.jooby.internal.whoops.pebble.error.ParserException;
import org.jooby.internal.whoops.pebble.lexer.Token;
import org.jooby.internal.whoops.pebble.lexer.TokenStream;
import org.jooby.internal.whoops.pebble.node.BodyNode;
import org.jooby.internal.whoops.pebble.node.ForNode;
import org.jooby.internal.whoops.pebble.node.RenderableNode;
import org.jooby.internal.whoops.pebble.node.expression.Expression;
import org.jooby.internal.whoops.pebble.parser.Parser;
import org.jooby.internal.whoops.pebble.parser.StoppingCondition;
import org.jooby.internal.whoops.pebble.tokenParser.AbstractTokenParser;

public class ForTokenParser
extends AbstractTokenParser {
    private StoppingCondition decideForFork = new StoppingCondition(){

        @Override
        public boolean evaluate(Token token) {
            return token.test(Token.Type.NAME, "else", "endfor");
        }
    };
    private StoppingCondition decideForEnd = new StoppingCondition(){

        @Override
        public boolean evaluate(Token token) {
            return token.test(Token.Type.NAME, "endfor");
        }
    };

    @Override
    public RenderableNode parse(Token token, Parser parser) throws ParserException {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        String iterationVariable = parser.getExpressionParser().parseNewVariableName();
        stream.expect(Token.Type.NAME, "in");
        Expression<?> iterable = parser.getExpressionParser().parseExpression();
        stream.expect(Token.Type.EXECUTE_END);
        BodyNode body = parser.subparse(this.decideForFork);
        BodyNode elseBody = null;
        if (stream.current().test(Token.Type.NAME, "else")) {
            stream.next();
            stream.expect(Token.Type.EXECUTE_END);
            elseBody = parser.subparse(this.decideForEnd);
        }
        if (stream.current().getValue() == null) {
            throw new ParserException(null, "Unexpected end of template. Pebble was looking for the \"endfor\" tag", stream.current().getLineNumber(), stream.getFilename());
        }
        stream.next();
        stream.expect(Token.Type.EXECUTE_END);
        return new ForNode(lineNumber, iterationVariable, iterable, body, elseBody);
    }

    @Override
    public String getTag() {
        return "for";
    }
}

