/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooby.internal.whoops.pebble.error.PebbleException;
import org.jooby.internal.whoops.pebble.extension.NamedArguments;
import org.jooby.internal.whoops.pebble.extension.NodeVisitor;
import org.jooby.internal.whoops.pebble.node.NamedArgumentNode;
import org.jooby.internal.whoops.pebble.node.Node;
import org.jooby.internal.whoops.pebble.node.PositionalArgumentNode;
import org.jooby.internal.whoops.pebble.template.EvaluationContext;
import org.jooby.internal.whoops.pebble.template.PebbleTemplateImpl;

public class ArgumentsNode
implements Node {
    private final List<NamedArgumentNode> namedArgs;
    private final List<PositionalArgumentNode> positionalArgs;
    private final int lineNumber;

    public ArgumentsNode(List<PositionalArgumentNode> positionalArgs, List<NamedArgumentNode> namedArgs, int lineNumber) {
        this.positionalArgs = positionalArgs;
        this.namedArgs = namedArgs;
        this.lineNumber = lineNumber;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<NamedArgumentNode> getNamedArgs() {
        return this.namedArgs;
    }

    public List<PositionalArgumentNode> getPositionalArgs() {
        return this.positionalArgs;
    }

    public Map<String, Object> getArgumentMap(PebbleTemplateImpl self, EvaluationContext context, NamedArguments invocableWithNamedArguments) throws PebbleException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> argumentNames = invocableWithNamedArguments.getArgumentNames();
        if (argumentNames == null) {
            if (this.positionalArgs != null && !this.positionalArgs.isEmpty()) {
                for (int i = 0; i < this.positionalArgs.size(); ++i) {
                    result.put(String.valueOf(i), this.positionalArgs.get(i).getValueExpression().evaluate(self, context));
                }
            }
        } else {
            if (this.positionalArgs != null) {
                int nameIndex = 0;
                for (PositionalArgumentNode arg : this.positionalArgs) {
                    if (argumentNames.size() <= nameIndex) {
                        throw new PebbleException(null, "The argument at position " + (nameIndex + 1) + " is not allowed. Only " + argumentNames.size() + " argument(s) are allowed.", this.lineNumber, self.getName());
                    }
                    result.put(argumentNames.get(nameIndex), arg.getValueExpression().evaluate(self, context));
                    ++nameIndex;
                }
            }
            if (this.namedArgs != null) {
                for (NamedArgumentNode arg : this.namedArgs) {
                    if (!argumentNames.contains(arg.getName())) {
                        throw new PebbleException(null, "The following named argument does not exist: " + arg.getName(), this.lineNumber, self.getName());
                    }
                    Object value = arg.getValueExpression() == null ? null : (Object)arg.getValueExpression().evaluate(self, context);
                    result.put(arg.getName(), value);
                }
            }
        }
        result.put("_self", self);
        result.put("_context", context);
        return result;
    }
}

