/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.extension.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jooby.internal.whoops.pebble.extension.Filter;

public class SliceFilter
implements Filter {
    private final List<String> argumentNames = new ArrayList<String>();

    public SliceFilter() {
        this.argumentNames.add("fromIndex");
        this.argumentNames.add("toIndex");
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object input, Map<String, Object> args) {
        int to;
        int length;
        if (input == null) {
            return null;
        }
        Object argFrom = args.get("fromIndex");
        if (argFrom == null) {
            argFrom = 0L;
        } else if (!(argFrom instanceof Number)) {
            throw new IllegalArgumentException("Argument fromIndex must be a number. Actual type: " + (argFrom == null ? "null" : argFrom.getClass().getName()));
        }
        int from = ((Number)argFrom).intValue();
        if (from < 0) {
            throw new IllegalArgumentException("fromIndex must be greater than 0");
        }
        Object argTo = args.get("toIndex");
        if (argTo != null && !(argTo instanceof Number)) {
            throw new IllegalArgumentException("Argument toIndex must be a number. Actual type: " + (argTo == null ? "null" : argTo.getClass().getName()));
        }
        if (input instanceof List) {
            length = ((List)input).size();
        } else if (input.getClass().isArray()) {
            length = Array.getLength(input);
        } else if (input instanceof String) {
            length = ((String)input).length();
        } else {
            throw new IllegalArgumentException("Slice filter can only be applied to String, List and array inputs. Actual type was: " + input.getClass().getName());
        }
        if (argTo != null) {
            to = ((Number)argTo).intValue();
            if (to > length) {
                throw new IllegalArgumentException("toIndex must be smaller than input size: " + length);
            }
            if (from >= to) {
                throw new IllegalArgumentException("toIndex must be greater than fromIndex");
            }
        } else {
            to = length;
        }
        if (input instanceof List) {
            List value = (List)input;
            return value.subList(from, to);
        }
        if (input.getClass().isArray()) {
            return SliceFilter.sliceArray(input, from, to);
        }
        String value = (String)input;
        return value.substring(from, to);
    }

    private static Object sliceArray(Object input, int from, int to) {
        if (input instanceof Object[]) {
            return Arrays.copyOfRange((Object[])input, from, to);
        }
        if (input instanceof boolean[]) {
            return Arrays.copyOfRange((boolean[])input, from, to);
        }
        if (input instanceof byte[]) {
            return Arrays.copyOfRange((byte[])input, from, to);
        }
        if (input instanceof char[]) {
            return Arrays.copyOfRange((char[])input, from, to);
        }
        if (input instanceof double[]) {
            return Arrays.copyOfRange((double[])input, from, to);
        }
        if (input instanceof float[]) {
            return Arrays.copyOfRange((float[])input, from, to);
        }
        if (input instanceof int[]) {
            return Arrays.copyOfRange((int[])input, from, to);
        }
        if (input instanceof long[]) {
            return Arrays.copyOfRange((long[])input, from, to);
        }
        return Arrays.copyOfRange((short[])input, from, to);
    }
}

