/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.node.expression;

import org.jooby.internal.whoops.pebble.error.PebbleException;
import org.jooby.internal.whoops.pebble.error.RootAttributeNotFoundException;
import org.jooby.internal.whoops.pebble.extension.NodeVisitor;
import org.jooby.internal.whoops.pebble.node.expression.Expression;
import org.jooby.internal.whoops.pebble.template.EvaluationContext;
import org.jooby.internal.whoops.pebble.template.PebbleTemplateImpl;
import org.jooby.internal.whoops.pebble.template.ScopeChain;

public class ContextVariableExpression
implements Expression<Object> {
    protected final String name;
    private final int lineNumber;

    public ContextVariableExpression(String name, int lineNumber) {
        this.name = name;
        this.lineNumber = lineNumber;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object evaluate(PebbleTemplateImpl self, EvaluationContext context) throws PebbleException {
        ScopeChain scopeChain = context.getScopeChain();
        Object result = scopeChain.get(this.name);
        if (result == null && context.isStrictVariables() && !scopeChain.containsKey(this.name)) {
            throw new RootAttributeNotFoundException(null, String.format("Root attribute [%s] does not exist or can not be accessed and strict variables is set to true.", this.name), this.name, this.lineNumber, self.getName());
        }
        return result;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }
}

