/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.lexer;

import java.util.regex.Pattern;

public final class Syntax {
    private final String delimiterCommentOpen;
    private final String delimiterCommentClose;
    private final String delimiterExecuteOpen;
    private final String delimiterExecuteClose;
    private final String delimiterPrintOpen;
    private final String delimiterPrintClose;
    private final String whitespaceTrim;
    private final Pattern regexPrintClose;
    private final Pattern regexExecuteClose;
    private final Pattern regexCommentClose;
    private final Pattern regexStartDelimiters;
    private final Pattern regexLeadingWhitespaceTrim;
    private final Pattern regexTrailingWhitespaceTrim;
    private final Pattern regexVerbatimStart;
    private final Pattern regexVerbatimEnd;
    private static final String POSSIBLE_NEW_LINE = "(\r\n|\n\r|\r|\n|\u0085|\u2028|\u2029)?";

    public Syntax(String delimiterCommentOpen, String delimiterCommentClose, String delimiterExecuteOpen, String delimiterExecuteClose, String delimiterPrintOpen, String delimiterPrintClose, String whitespaceTrim, boolean enableNewLineTrimming) {
        this.delimiterCommentClose = delimiterCommentClose;
        this.delimiterCommentOpen = delimiterCommentOpen;
        this.delimiterExecuteOpen = delimiterExecuteOpen;
        this.delimiterExecuteClose = delimiterExecuteClose;
        this.delimiterPrintOpen = delimiterPrintOpen;
        this.delimiterPrintClose = delimiterPrintClose;
        this.whitespaceTrim = whitespaceTrim;
        String newlineRegexSuffix = enableNewLineTrimming ? POSSIBLE_NEW_LINE : "";
        this.regexPrintClose = Pattern.compile("^\\s*" + Pattern.quote(whitespaceTrim) + "?" + Pattern.quote(delimiterPrintClose) + newlineRegexSuffix);
        this.regexExecuteClose = Pattern.compile("^\\s*" + Pattern.quote(whitespaceTrim) + "?" + Pattern.quote(delimiterExecuteClose) + newlineRegexSuffix);
        this.regexCommentClose = Pattern.compile(Pattern.quote(delimiterCommentClose) + newlineRegexSuffix);
        this.regexStartDelimiters = Pattern.compile(Pattern.quote(delimiterPrintOpen) + "|" + Pattern.quote(delimiterExecuteOpen) + "|" + Pattern.quote(delimiterCommentOpen));
        this.regexVerbatimStart = Pattern.compile("^\\s*verbatim\\s*(" + Pattern.quote(whitespaceTrim) + ")?" + Pattern.quote(delimiterExecuteClose) + newlineRegexSuffix);
        this.regexVerbatimEnd = Pattern.compile(Pattern.quote(delimiterExecuteOpen) + "(" + Pattern.quote(whitespaceTrim) + ")?" + "\\s*endverbatim\\s*(" + Pattern.quote(whitespaceTrim) + ")?" + Pattern.quote(delimiterExecuteClose) + newlineRegexSuffix);
        this.regexLeadingWhitespaceTrim = Pattern.compile(Pattern.quote(whitespaceTrim) + "\\s+");
        this.regexTrailingWhitespaceTrim = Pattern.compile("^\\s*" + Pattern.quote(whitespaceTrim) + "(" + Pattern.quote(delimiterPrintClose) + "|" + Pattern.quote(delimiterExecuteClose) + "|" + Pattern.quote(delimiterCommentClose) + ")");
    }

    public String getCommentOpenDelimiter() {
        return this.delimiterCommentOpen;
    }

    public String getCommentCloseDelimiter() {
        return this.delimiterCommentClose;
    }

    public String getExecuteOpenDelimiter() {
        return this.delimiterExecuteOpen;
    }

    public String getExecuteCloseDelimiter() {
        return this.delimiterExecuteClose;
    }

    public String getPrintOpenDelimiter() {
        return this.delimiterPrintOpen;
    }

    public String getPrintCloseDelimiter() {
        return this.delimiterPrintClose;
    }

    public String getWhitespaceTrim() {
        return this.whitespaceTrim;
    }

    Pattern getRegexPrintClose() {
        return this.regexPrintClose;
    }

    Pattern getRegexExecuteClose() {
        return this.regexExecuteClose;
    }

    Pattern getRegexCommentClose() {
        return this.regexCommentClose;
    }

    Pattern getRegexStartDelimiters() {
        return this.regexStartDelimiters;
    }

    Pattern getRegexLeadingWhitespaceTrim() {
        return this.regexLeadingWhitespaceTrim;
    }

    Pattern getRegexTrailingWhitespaceTrim() {
        return this.regexTrailingWhitespaceTrim;
    }

    Pattern getRegexVerbatimEnd() {
        return this.regexVerbatimEnd;
    }

    Pattern getRegexVerbatimStart() {
        return this.regexVerbatimStart;
    }

    public static class Builder {
        private String delimiterCommentOpen = "{#";
        private String delimiterCommentClose = "#}";
        private String delimiterExecuteOpen = "{%";
        private String delimiterExecuteClose = "%}";
        private String delimiterPrintOpen = "{{";
        private String delimiterPrintClose = "}}";
        private String whitespaceTrim = "-";
        private boolean enableNewLineTrimming = true;

        public String getCommentOpenDelimiter() {
            return this.delimiterCommentOpen;
        }

        public Builder setCommentOpenDelimiter(String commentOpenDelimiter) {
            this.delimiterCommentOpen = commentOpenDelimiter;
            return this;
        }

        public String getCommentCloseDelimiter() {
            return this.delimiterCommentClose;
        }

        public Builder setCommentCloseDelimiter(String commentCloseDelimiter) {
            this.delimiterCommentClose = commentCloseDelimiter;
            return this;
        }

        public String getExecuteOpenDelimiter() {
            return this.delimiterExecuteOpen;
        }

        public Builder setExecuteOpenDelimiter(String executeOpenDelimiter) {
            this.delimiterExecuteOpen = executeOpenDelimiter;
            return this;
        }

        public String getExecuteCloseDelimiter() {
            return this.delimiterExecuteClose;
        }

        public Builder setExecuteCloseDelimiter(String executeCloseDelimiter) {
            this.delimiterExecuteClose = executeCloseDelimiter;
            return this;
        }

        public String getPrintOpenDelimiter() {
            return this.delimiterPrintOpen;
        }

        public Builder setPrintOpenDelimiter(String printOpenDelimiter) {
            this.delimiterPrintOpen = printOpenDelimiter;
            return this;
        }

        public String getPrintCloseDelimiter() {
            return this.delimiterPrintClose;
        }

        public Builder setPrintCloseDelimiter(String printCloseDelimiter) {
            this.delimiterPrintClose = printCloseDelimiter;
            return this;
        }

        public String getWhitespaceTrim() {
            return this.whitespaceTrim;
        }

        public Builder setWhitespaceTrim(String whitespaceTrim) {
            this.whitespaceTrim = whitespaceTrim;
            return this;
        }

        public boolean isEnableNewLineTrimming() {
            return this.enableNewLineTrimming;
        }

        public Builder setEnableNewLineTrimming(boolean enableNewLineTrimming) {
            this.enableNewLineTrimming = enableNewLineTrimming;
            return this;
        }

        public Syntax build() {
            return new Syntax(this.delimiterCommentOpen, this.delimiterCommentClose, this.delimiterExecuteOpen, this.delimiterExecuteClose, this.delimiterPrintOpen, this.delimiterPrintClose, this.whitespaceTrim, this.enableNewLineTrimming);
        }
    }
}

