/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PathUtils {
    private static final Pattern separatorRegex = Pattern.compile("\\\\|/");

    public static String resolveRelativePath(String relativePath, String anchorPath, char expectedSeparator) {
        if (relativePath == null || relativePath.isEmpty()) {
            return null;
        }
        relativePath = PathUtils.sanitize(relativePath, expectedSeparator);
        anchorPath = PathUtils.sanitize(anchorPath, expectedSeparator);
        if (relativePath.startsWith(".." + expectedSeparator) || relativePath.startsWith("." + expectedSeparator)) {
            return PathUtils.resolvePathInner(relativePath, anchorPath, expectedSeparator);
        }
        return null;
    }

    private static String sanitize(String path, char expectedSeparator) {
        return separatorRegex.matcher(path).replaceAll(Matcher.quoteReplacement(String.valueOf(expectedSeparator)));
    }

    private static String resolvePathInner(String relativePath, String anchorPath, char separator) {
        StringBuilder resultingPath = new StringBuilder();
        for (String segment : PathUtils.resolvePathSegments(PathUtils.determineAnchorPathSegments(anchorPath, separator), PathUtils.splitBySeparator(relativePath, separator))) {
            resultingPath.append(segment).append(separator);
        }
        return resultingPath.substring(0, resultingPath.length() - 1);
    }

    private static Collection<String> determineAnchorPathSegments(String anchorPath, char separator) {
        if (anchorPath == null || anchorPath.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayDeque<String> anchorPathSegments = new ArrayDeque<String>(PathUtils.splitBySeparator(anchorPath, separator));
        if (anchorPath.charAt(anchorPath.length() - 1) != separator) {
            anchorPathSegments.pollLast();
        }
        return anchorPathSegments;
    }

    private static Collection<String> resolvePathSegments(Collection<String> anchorSegments, Collection<String> relativeSegments) {
        ArrayDeque<String> result = new ArrayDeque<String>(anchorSegments);
        for (String segment : relativeSegments) {
            if (segment.equals(".")) continue;
            if (segment.equals("..")) {
                result.pollLast();
                continue;
            }
            result.add(segment);
        }
        return result;
    }

    private static List<String> splitBySeparator(String path, char separator) {
        return Arrays.asList(path.split(Pattern.quote(String.valueOf(separator))));
    }

    private PathUtils() {
        throw new IllegalAccessError();
    }
}

