/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.extension.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooby.internal.whoops.pebble.extension.AbstractExtension;
import org.jooby.internal.whoops.pebble.extension.Filter;
import org.jooby.internal.whoops.pebble.extension.Function;
import org.jooby.internal.whoops.pebble.extension.NodeVisitorFactory;
import org.jooby.internal.whoops.pebble.extension.Test;
import org.jooby.internal.whoops.pebble.extension.core.AbbreviateFilter;
import org.jooby.internal.whoops.pebble.extension.core.AbsFilter;
import org.jooby.internal.whoops.pebble.extension.core.CapitalizeFilter;
import org.jooby.internal.whoops.pebble.extension.core.DateFilter;
import org.jooby.internal.whoops.pebble.extension.core.DefaultFilter;
import org.jooby.internal.whoops.pebble.extension.core.DefinedTest;
import org.jooby.internal.whoops.pebble.extension.core.EmptyTest;
import org.jooby.internal.whoops.pebble.extension.core.EvenTest;
import org.jooby.internal.whoops.pebble.extension.core.FirstFilter;
import org.jooby.internal.whoops.pebble.extension.core.IterableTest;
import org.jooby.internal.whoops.pebble.extension.core.JoinFilter;
import org.jooby.internal.whoops.pebble.extension.core.LastFilter;
import org.jooby.internal.whoops.pebble.extension.core.LengthFilter;
import org.jooby.internal.whoops.pebble.extension.core.LowerFilter;
import org.jooby.internal.whoops.pebble.extension.core.MacroAndBlockRegistrantNodeVisitorFactory;
import org.jooby.internal.whoops.pebble.extension.core.MapTest;
import org.jooby.internal.whoops.pebble.extension.core.MaxFunction;
import org.jooby.internal.whoops.pebble.extension.core.MergeFilter;
import org.jooby.internal.whoops.pebble.extension.core.MinFunction;
import org.jooby.internal.whoops.pebble.extension.core.NullTest;
import org.jooby.internal.whoops.pebble.extension.core.NumberFormatFilter;
import org.jooby.internal.whoops.pebble.extension.core.OddTest;
import org.jooby.internal.whoops.pebble.extension.core.RangeFunction;
import org.jooby.internal.whoops.pebble.extension.core.ReplaceFilter;
import org.jooby.internal.whoops.pebble.extension.core.RsortFilter;
import org.jooby.internal.whoops.pebble.extension.core.SliceFilter;
import org.jooby.internal.whoops.pebble.extension.core.SortFilter;
import org.jooby.internal.whoops.pebble.extension.core.TitleFilter;
import org.jooby.internal.whoops.pebble.extension.core.TrimFilter;
import org.jooby.internal.whoops.pebble.extension.core.UpperFilter;
import org.jooby.internal.whoops.pebble.extension.core.UrlEncoderFilter;
import org.jooby.internal.whoops.pebble.node.expression.AddExpression;
import org.jooby.internal.whoops.pebble.node.expression.AndExpression;
import org.jooby.internal.whoops.pebble.node.expression.ConcatenateExpression;
import org.jooby.internal.whoops.pebble.node.expression.ContainsExpression;
import org.jooby.internal.whoops.pebble.node.expression.DivideExpression;
import org.jooby.internal.whoops.pebble.node.expression.EqualsExpression;
import org.jooby.internal.whoops.pebble.node.expression.FilterExpression;
import org.jooby.internal.whoops.pebble.node.expression.GreaterThanEqualsExpression;
import org.jooby.internal.whoops.pebble.node.expression.GreaterThanExpression;
import org.jooby.internal.whoops.pebble.node.expression.LessThanEqualsExpression;
import org.jooby.internal.whoops.pebble.node.expression.LessThanExpression;
import org.jooby.internal.whoops.pebble.node.expression.ModulusExpression;
import org.jooby.internal.whoops.pebble.node.expression.MultiplyExpression;
import org.jooby.internal.whoops.pebble.node.expression.NegativeTestExpression;
import org.jooby.internal.whoops.pebble.node.expression.NotEqualsExpression;
import org.jooby.internal.whoops.pebble.node.expression.OrExpression;
import org.jooby.internal.whoops.pebble.node.expression.PositiveTestExpression;
import org.jooby.internal.whoops.pebble.node.expression.RangeExpression;
import org.jooby.internal.whoops.pebble.node.expression.SubtractExpression;
import org.jooby.internal.whoops.pebble.node.expression.UnaryMinusExpression;
import org.jooby.internal.whoops.pebble.node.expression.UnaryNotExpression;
import org.jooby.internal.whoops.pebble.node.expression.UnaryPlusExpression;
import org.jooby.internal.whoops.pebble.operator.Associativity;
import org.jooby.internal.whoops.pebble.operator.BinaryOperator;
import org.jooby.internal.whoops.pebble.operator.BinaryOperatorImpl;
import org.jooby.internal.whoops.pebble.operator.UnaryOperator;
import org.jooby.internal.whoops.pebble.operator.UnaryOperatorImpl;
import org.jooby.internal.whoops.pebble.tokenParser.BlockTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.CacheTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.ExtendsTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.FilterTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.FlushTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.ForTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.IfTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.ImportTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.IncludeTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.MacroTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.ParallelTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.SetTokenParser;
import org.jooby.internal.whoops.pebble.tokenParser.TokenParser;

public class CoreExtension
extends AbstractExtension {
    @Override
    public List<TokenParser> getTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>();
        parsers.add(new BlockTokenParser());
        parsers.add(new ExtendsTokenParser());
        parsers.add(new FilterTokenParser());
        parsers.add(new FlushTokenParser());
        parsers.add(new ForTokenParser());
        parsers.add(new IfTokenParser());
        parsers.add(new ImportTokenParser());
        parsers.add(new IncludeTokenParser());
        parsers.add(new MacroTokenParser());
        parsers.add(new ParallelTokenParser());
        parsers.add(new SetTokenParser());
        parsers.add(new CacheTokenParser());
        return parsers;
    }

    @Override
    public List<UnaryOperator> getUnaryOperators() {
        ArrayList<UnaryOperator> operators = new ArrayList<UnaryOperator>();
        operators.add(new UnaryOperatorImpl("not", 5, UnaryNotExpression.class));
        operators.add(new UnaryOperatorImpl("+", 500, UnaryPlusExpression.class));
        operators.add(new UnaryOperatorImpl("-", 500, UnaryMinusExpression.class));
        return operators;
    }

    @Override
    public List<BinaryOperator> getBinaryOperators() {
        ArrayList<BinaryOperator> operators = new ArrayList<BinaryOperator>();
        operators.add(new BinaryOperatorImpl("or", 10, OrExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("and", 15, AndExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("is", 20, PositiveTestExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("is not", 20, NegativeTestExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("contains", 20, ContainsExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("==", 30, EqualsExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("equals", 30, EqualsExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("!=", 30, NotEqualsExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl(">", 30, GreaterThanExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("<", 30, LessThanExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl(">=", 30, GreaterThanEqualsExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("<=", 30, LessThanEqualsExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("+", 40, AddExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("-", 40, SubtractExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("*", 60, MultiplyExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("/", 60, DivideExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("%", 60, ModulusExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("|", 100, FilterExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("~", 110, ConcatenateExpression.class, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("..", 120, RangeExpression.class, Associativity.LEFT));
        return operators;
    }

    @Override
    public Map<String, Filter> getFilters() {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        filters.put("abbreviate", new AbbreviateFilter());
        filters.put("abs", new AbsFilter());
        filters.put("capitalize", new CapitalizeFilter());
        filters.put("date", new DateFilter());
        filters.put("default", new DefaultFilter());
        filters.put("first", new FirstFilter());
        filters.put("join", new JoinFilter());
        filters.put("last", new LastFilter());
        filters.put("lower", new LowerFilter());
        filters.put("numberformat", new NumberFormatFilter());
        filters.put("slice", new SliceFilter());
        filters.put("sort", new SortFilter());
        filters.put("rsort", new RsortFilter());
        filters.put("title", new TitleFilter());
        filters.put("trim", new TrimFilter());
        filters.put("upper", new UpperFilter());
        filters.put("urlencode", new UrlEncoderFilter());
        filters.put("length", new LengthFilter());
        filters.put("replace", new ReplaceFilter());
        filters.put("merge", new MergeFilter());
        return filters;
    }

    @Override
    public Map<String, Test> getTests() {
        HashMap<String, Test> tests = new HashMap<String, Test>();
        tests.put("empty", new EmptyTest());
        tests.put("even", new EvenTest());
        tests.put("iterable", new IterableTest());
        tests.put("map", new MapTest());
        tests.put("null", new NullTest());
        tests.put("odd", new OddTest());
        tests.put("defined", new DefinedTest());
        return tests;
    }

    @Override
    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put("max", new MaxFunction());
        functions.put("min", new MinFunction());
        functions.put("range", new RangeFunction());
        return functions;
    }

    @Override
    public Map<String, Object> getGlobalVariables() {
        return null;
    }

    @Override
    public List<NodeVisitorFactory> getNodeVisitors() {
        ArrayList<NodeVisitorFactory> visitors = new ArrayList<NodeVisitorFactory>();
        visitors.add(new MacroAndBlockRegistrantNodeVisitorFactory());
        return visitors;
    }
}

