/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.extension.escaper;

import java.util.ArrayList;
import java.util.LinkedList;
import org.jooby.internal.whoops.pebble.extension.AbstractNodeVisitor;
import org.jooby.internal.whoops.pebble.node.ArgumentsNode;
import org.jooby.internal.whoops.pebble.node.AutoEscapeNode;
import org.jooby.internal.whoops.pebble.node.NamedArgumentNode;
import org.jooby.internal.whoops.pebble.node.PrintNode;
import org.jooby.internal.whoops.pebble.node.expression.BlockFunctionExpression;
import org.jooby.internal.whoops.pebble.node.expression.Expression;
import org.jooby.internal.whoops.pebble.node.expression.FilterExpression;
import org.jooby.internal.whoops.pebble.node.expression.FilterInvocationExpression;
import org.jooby.internal.whoops.pebble.node.expression.LiteralStringExpression;
import org.jooby.internal.whoops.pebble.node.expression.ParentFunctionExpression;
import org.jooby.internal.whoops.pebble.node.expression.TernaryExpression;
import org.jooby.internal.whoops.pebble.template.PebbleTemplateImpl;

public class EscaperNodeVisitor
extends AbstractNodeVisitor {
    private final LinkedList<String> strategies = new LinkedList();
    private final LinkedList<Boolean> active = new LinkedList();

    public EscaperNodeVisitor(PebbleTemplateImpl template, boolean autoEscapting) {
        super(template);
        this.pushAutoEscapeState(autoEscapting);
    }

    @Override
    public void visit(PrintNode node) {
        Expression<?> expression = node.getExpression();
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            Expression<?> left = ternary.getExpression2();
            Expression<?> right = ternary.getExpression3();
            if (!this.isSafe(left)) {
                ternary.setExpression2(this.escape(left));
            }
            if (!this.isSafe(right)) {
                ternary.setExpression3(this.escape(right));
            }
        } else if (!this.isSafe(expression)) {
            node.setExpression(this.escape(expression));
        }
    }

    @Override
    public void visit(AutoEscapeNode node) {
        this.active.push(node.isActive());
        this.strategies.push(node.getStrategy());
        node.getBody().accept(this);
        this.active.pop();
        this.strategies.pop();
    }

    private Expression<?> escape(Expression<?> expression) {
        ArrayList<NamedArgumentNode> namedArgs = new ArrayList<NamedArgumentNode>();
        if (!this.strategies.isEmpty() && this.strategies.peek() != null) {
            String strategy = this.strategies.peek();
            namedArgs.add(new NamedArgumentNode("strategy", new LiteralStringExpression(strategy, expression.getLineNumber())));
        }
        ArgumentsNode args = new ArgumentsNode(null, namedArgs, expression.getLineNumber());
        FilterInvocationExpression filter = new FilterInvocationExpression("escape", args, expression.getLineNumber());
        FilterExpression binary = new FilterExpression();
        binary.setLeft(expression);
        binary.setRight(filter);
        return binary;
    }

    private boolean isSafe(Expression<?> expression) {
        if (!this.active.isEmpty() && !this.active.peek().booleanValue()) {
            return true;
        }
        boolean safe = false;
        if (expression instanceof LiteralStringExpression) {
            safe = true;
        } else if (expression instanceof ParentFunctionExpression || expression instanceof BlockFunctionExpression) {
            safe = true;
        }
        return safe;
    }

    public void pushAutoEscapeState(boolean auto) {
        this.active.push(auto);
    }
}

