/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.node;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jooby.internal.whoops.pebble.error.PebbleException;
import org.jooby.internal.whoops.pebble.extension.NodeVisitor;
import org.jooby.internal.whoops.pebble.node.AbstractRenderableNode;
import org.jooby.internal.whoops.pebble.node.ImportNode;
import org.jooby.internal.whoops.pebble.node.Node;
import org.jooby.internal.whoops.pebble.node.RenderableNode;
import org.jooby.internal.whoops.pebble.node.SetNode;
import org.jooby.internal.whoops.pebble.template.EvaluationContext;
import org.jooby.internal.whoops.pebble.template.PebbleTemplateImpl;

public class BodyNode
extends AbstractRenderableNode {
    private final List<RenderableNode> children;
    private boolean onlyRenderInheritanceSafeNodes = false;
    private static List<Class<? extends Node>> nodesToRenderInChild = new ArrayList<Class<? extends Node>>();

    public BodyNode(int lineNumber, List<RenderableNode> children) {
        super(lineNumber);
        this.children = children;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContext context) throws PebbleException, IOException {
        for (RenderableNode child : this.children) {
            if (this.onlyRenderInheritanceSafeNodes && context.getHierarchy().getParent() != null && !nodesToRenderInChild.contains(child.getClass())) continue;
            child.render(self, writer, context);
        }
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<RenderableNode> getChildren() {
        return this.children;
    }

    public boolean isOnlyRenderInheritanceSafeNodes() {
        return this.onlyRenderInheritanceSafeNodes;
    }

    public void setOnlyRenderInheritanceSafeNodes(boolean onlyRenderInheritanceSafeNodes) {
        this.onlyRenderInheritanceSafeNodes = onlyRenderInheritanceSafeNodes;
    }

    static {
        nodesToRenderInChild.add(SetNode.class);
        nodesToRenderInChild.add(ImportNode.class);
    }
}

