/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.whoops.pebble.node;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.jooby.internal.whoops.pebble.error.PebbleException;
import org.jooby.internal.whoops.pebble.extension.NodeVisitor;
import org.jooby.internal.whoops.pebble.node.AbstractRenderableNode;
import org.jooby.internal.whoops.pebble.node.expression.Expression;
import org.jooby.internal.whoops.pebble.node.expression.MapExpression;
import org.jooby.internal.whoops.pebble.template.EvaluationContext;
import org.jooby.internal.whoops.pebble.template.PebbleTemplateImpl;

public class IncludeNode
extends AbstractRenderableNode {
    private final Expression<?> includeExpression;
    private final MapExpression mapExpression;

    public IncludeNode(int lineNumber, Expression<?> includeExpression, MapExpression mapExpression) {
        super(lineNumber);
        this.includeExpression = includeExpression;
        this.mapExpression = mapExpression;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContext context) throws PebbleException, IOException {
        String templateName = (String)this.includeExpression.evaluate(self, context);
        Object map = Collections.emptyMap();
        if (this.mapExpression != null) {
            map = this.mapExpression.evaluate(self, context);
        }
        if (templateName == null) {
            throw new PebbleException(null, String.format("The template name in an include tag evaluated to NULL. If the template name is static, make sure to wrap it in quotes.", templateName), this.getLineNumber(), self.getName());
        }
        self.includeTemplate(writer, context, templateName, (Map<?, ?>)map);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public Expression<?> getIncludeExpression() {
        return this.includeExpression;
    }
}

