/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.typesafe.config.Config;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.MediaType;
import org.jooby.Parser;
import org.jooby.Renderer;
import org.jooby.json.YassonParser;
import org.jooby.json.YassonRawRenderer;
import org.jooby.json.YassonRenderer;

public class Yasson
implements Jooby.Module {
    private final MediaType type;
    private BiConsumer<JsonbConfig, Config> configurer;
    private boolean raw;

    public Yasson(MediaType type) {
        this.type = Objects.requireNonNull(type, "Media type is required.");
    }

    public Yasson() {
        this(MediaType.json);
    }

    public Yasson doWith(BiConsumer<JsonbConfig, Config> configurer) {
        this.configurer = Objects.requireNonNull(configurer, "Configurer callback is required.");
        return this;
    }

    public Yasson doWith(Consumer<JsonbConfig> configurer) {
        Objects.requireNonNull(configurer, "Configurer callback is required.");
        this.configurer = (jsonConfig, conf) -> configurer.accept((JsonbConfig)jsonConfig);
        return this;
    }

    public void configure(Env env, Config config, Binder binder) {
        JsonbConfig jsonbConfig = new JsonbConfig();
        if (this.configurer != null) {
            this.configurer.accept(jsonbConfig, config);
        }
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)jsonbConfig);
        binder.bind(Jsonb.class).toInstance((Object)jsonb);
        Multibinder.newSetBinder((Binder)binder, Parser.class).addBinding().toInstance((Object)new YassonParser(this.type, jsonb));
        YassonRenderer renderer = this.raw ? new YassonRawRenderer(this.type, jsonb) : new YassonRenderer(this.type, jsonb);
        Multibinder.newSetBinder((Binder)binder, Renderer.class).addBinding().toInstance((Object)renderer);
    }

    public Yasson raw() {
        this.raw = true;
        return this;
    }
}

