/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import java.util.Objects;
import javax.json.bind.Jsonb;
import org.jooby.MediaType;
import org.jooby.Renderer;

public class YassonRenderer
implements Renderer {
    protected final MediaType type;
    private final Jsonb jsonb;

    public YassonRenderer(MediaType type, Jsonb jsonb) {
        this.type = Objects.requireNonNull(type, "Media type is required.");
        this.jsonb = Objects.requireNonNull(jsonb, "Jsonb is required.");
    }

    public void render(Object object, Renderer.Context ctx) throws Exception {
        if (ctx.accepts(this.type)) {
            ctx.type(this.type).send(this.jsonb.toJson(object));
        }
    }

    public String name() {
        return "json";
    }

    public String toString() {
        return this.name();
    }
}

